package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface NamedClusterRoleFluent<A extends NamedClusterRoleFluent<A>> extends Fluent<A>{


    public String getName();
    public A withName(String name);
    public ClusterRole getRole();
    public A withRole(ClusterRole role);
    public NamedClusterRoleFluent.RoleNested<A> withNewRole();
    public NamedClusterRoleFluent.RoleNested<A> withNewRoleLike(ClusterRole item);
    public NamedClusterRoleFluent.RoleNested<A> editRole();

    public interface RoleNested<N> extends Nested<N>,ClusterRoleFluent<NamedClusterRoleFluent.RoleNested<N>>{

        
    public N endRole();    public N and();
}


}
