package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.util.Map;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;

public interface ImageSignatureFluent<A extends ImageSignatureFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToConditions(SignatureCondition... items);
    public A removeFromConditions(SignatureCondition... items);
    public List<SignatureCondition> getConditions();
    public A withConditions(List<SignatureCondition> conditions);
    public A withConditions(SignatureCondition... conditions);
    public ImageSignatureFluent.ConditionsNested<A> addNewCondition();
    public ImageSignatureFluent.ConditionsNested<A> addNewConditionLike(SignatureCondition item);
    public String getContent();
    public A withContent(String content);
    public String getCreated();
    public A withCreated(String created);
    public String getImageIdentity();
    public A withImageIdentity(String imageIdentity);
    public SignatureIssuer getIssuedBy();
    public A withIssuedBy(SignatureIssuer issuedBy);
    public ImageSignatureFluent.IssuedByNested<A> withNewIssuedBy();
    public ImageSignatureFluent.IssuedByNested<A> withNewIssuedByLike(SignatureIssuer item);
    public ImageSignatureFluent.IssuedByNested<A> editIssuedBy();
    public A withNewIssuedBy(String commonName,String organization);
    public SignatureSubject getIssuedTo();
    public A withIssuedTo(SignatureSubject issuedTo);
    public ImageSignatureFluent.IssuedToNested<A> withNewIssuedTo();
    public ImageSignatureFluent.IssuedToNested<A> withNewIssuedToLike(SignatureSubject item);
    public ImageSignatureFluent.IssuedToNested<A> editIssuedTo();
    public A withNewIssuedTo(String commonName,String organization,String publicKeyID);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public ImageSignatureFluent.MetadataNested<A> withNewMetadata();
    public ImageSignatureFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ImageSignatureFluent.MetadataNested<A> editMetadata();
    public A addToSignedClaims(String key,String value);
    public A addToSignedClaims(Map<String,String> map);
    public A removeFromSignedClaims(String key);
    public A removeFromSignedClaims(Map<String,String> map);
    public Map<String,String> getSignedClaims();
    public A withSignedClaims(Map<String,String> signedClaims);
    public String getType();
    public A withType(String type);

    public interface ConditionsNested<N> extends Nested<N>,SignatureConditionFluent<ImageSignatureFluent.ConditionsNested<N>>{

        
    public N endCondition();    public N and();
}
    public interface IssuedByNested<N> extends Nested<N>,SignatureIssuerFluent<ImageSignatureFluent.IssuedByNested<N>>{

        
    public N endIssuedBy();    public N and();
}
    public interface IssuedToNested<N> extends Nested<N>,SignatureSubjectFluent<ImageSignatureFluent.IssuedToNested<N>>{

        
    public N and();    public N endIssuedTo();
}
    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<ImageSignatureFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
