package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;

public interface IdentityListFluent<A extends IdentityListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(Identity... items);
    public A removeFromItems(Identity... items);
    public List<Identity> getItems();
    public A withItems(List<Identity> items);
    public A withItems(Identity... items);
    public IdentityListFluent.ItemsNested<A> addNewItem();
    public IdentityListFluent.ItemsNested<A> addNewItemLike(Identity item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public IdentityListFluent.MetadataNested<A> withNewMetadata();
    public IdentityListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public IdentityListFluent.MetadataNested<A> editMetadata();
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,IdentityFluent<IdentityListFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<IdentityListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
