package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class BuildStrategyFluentImpl<A extends BuildStrategyFluent<A>> extends BaseFluent<A> implements BuildStrategyFluent<A>{

    private VisitableBuilder<? extends CustomBuildStrategy,?> customStrategy;
    private VisitableBuilder<? extends DockerBuildStrategy,?> dockerStrategy;
    private VisitableBuilder<? extends JenkinsPipelineBuildStrategy,?> jenkinsPipelineStrategy;
    private VisitableBuilder<? extends SourceBuildStrategy,?> sourceStrategy;
    private String type;

    public BuildStrategyFluentImpl(){
    }
    public BuildStrategyFluentImpl(BuildStrategy instance){
            this.withCustomStrategy(instance.getCustomStrategy()); 
            this.withDockerStrategy(instance.getDockerStrategy()); 
            this.withJenkinsPipelineStrategy(instance.getJenkinsPipelineStrategy()); 
            this.withSourceStrategy(instance.getSourceStrategy()); 
            this.withType(instance.getType()); 
    }

    public CustomBuildStrategy getCustomStrategy(){
            return this.customStrategy!=null?this.customStrategy.build():null;
    }

    public A withCustomStrategy(CustomBuildStrategy customStrategy){
            if (customStrategy!=null){ this.customStrategy= new CustomBuildStrategyBuilder(customStrategy); _visitables.add(this.customStrategy);} return (A) this;
    }

    public BuildStrategyFluent.CustomStrategyNested<A> withNewCustomStrategy(){
            return new CustomStrategyNestedImpl();
    }

    public BuildStrategyFluent.CustomStrategyNested<A> withNewCustomStrategyLike(CustomBuildStrategy item){
            return new CustomStrategyNestedImpl(item);
    }

    public BuildStrategyFluent.CustomStrategyNested<A> editCustomStrategy(){
            return withNewCustomStrategyLike(getCustomStrategy());
    }

    public DockerBuildStrategy getDockerStrategy(){
            return this.dockerStrategy!=null?this.dockerStrategy.build():null;
    }

    public A withDockerStrategy(DockerBuildStrategy dockerStrategy){
            if (dockerStrategy!=null){ this.dockerStrategy= new DockerBuildStrategyBuilder(dockerStrategy); _visitables.add(this.dockerStrategy);} return (A) this;
    }

    public BuildStrategyFluent.DockerStrategyNested<A> withNewDockerStrategy(){
            return new DockerStrategyNestedImpl();
    }

    public BuildStrategyFluent.DockerStrategyNested<A> withNewDockerStrategyLike(DockerBuildStrategy item){
            return new DockerStrategyNestedImpl(item);
    }

    public BuildStrategyFluent.DockerStrategyNested<A> editDockerStrategy(){
            return withNewDockerStrategyLike(getDockerStrategy());
    }

    public JenkinsPipelineBuildStrategy getJenkinsPipelineStrategy(){
            return this.jenkinsPipelineStrategy!=null?this.jenkinsPipelineStrategy.build():null;
    }

    public A withJenkinsPipelineStrategy(JenkinsPipelineBuildStrategy jenkinsPipelineStrategy){
            if (jenkinsPipelineStrategy!=null){ this.jenkinsPipelineStrategy= new JenkinsPipelineBuildStrategyBuilder(jenkinsPipelineStrategy); _visitables.add(this.jenkinsPipelineStrategy);} return (A) this;
    }

    public BuildStrategyFluent.JenkinsPipelineStrategyNested<A> withNewJenkinsPipelineStrategy(){
            return new JenkinsPipelineStrategyNestedImpl();
    }

    public BuildStrategyFluent.JenkinsPipelineStrategyNested<A> withNewJenkinsPipelineStrategyLike(JenkinsPipelineBuildStrategy item){
            return new JenkinsPipelineStrategyNestedImpl(item);
    }

    public BuildStrategyFluent.JenkinsPipelineStrategyNested<A> editJenkinsPipelineStrategy(){
            return withNewJenkinsPipelineStrategyLike(getJenkinsPipelineStrategy());
    }

    public A withNewJenkinsPipelineStrategy(String jenkinsfile,String jenkinsfilePath){
            return (A)withJenkinsPipelineStrategy(new JenkinsPipelineBuildStrategy(jenkinsfile, jenkinsfilePath));
    }

    public SourceBuildStrategy getSourceStrategy(){
            return this.sourceStrategy!=null?this.sourceStrategy.build():null;
    }

    public A withSourceStrategy(SourceBuildStrategy sourceStrategy){
            if (sourceStrategy!=null){ this.sourceStrategy= new SourceBuildStrategyBuilder(sourceStrategy); _visitables.add(this.sourceStrategy);} return (A) this;
    }

    public BuildStrategyFluent.SourceStrategyNested<A> withNewSourceStrategy(){
            return new SourceStrategyNestedImpl();
    }

    public BuildStrategyFluent.SourceStrategyNested<A> withNewSourceStrategyLike(SourceBuildStrategy item){
            return new SourceStrategyNestedImpl(item);
    }

    public BuildStrategyFluent.SourceStrategyNested<A> editSourceStrategy(){
            return withNewSourceStrategyLike(getSourceStrategy());
    }

    public String getType(){
            return this.type;
    }

    public A withType(String type){
            this.type=type; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            BuildStrategyFluentImpl that = (BuildStrategyFluentImpl) o;
            if (customStrategy != null ? !customStrategy.equals(that.customStrategy) :that.customStrategy != null) return false;
            if (dockerStrategy != null ? !dockerStrategy.equals(that.dockerStrategy) :that.dockerStrategy != null) return false;
            if (jenkinsPipelineStrategy != null ? !jenkinsPipelineStrategy.equals(that.jenkinsPipelineStrategy) :that.jenkinsPipelineStrategy != null) return false;
            if (sourceStrategy != null ? !sourceStrategy.equals(that.sourceStrategy) :that.sourceStrategy != null) return false;
            if (type != null ? !type.equals(that.type) :that.type != null) return false;
            return true;
    }


    public class CustomStrategyNestedImpl<N> extends CustomBuildStrategyFluentImpl<BuildStrategyFluent.CustomStrategyNested<N>> implements BuildStrategyFluent.CustomStrategyNested<N>,Nested<N>{

            private final CustomBuildStrategyBuilder builder;
    
            CustomStrategyNestedImpl(CustomBuildStrategy item){
                    this.builder = new CustomBuildStrategyBuilder(this, item);
            }
            CustomStrategyNestedImpl(){
                    this.builder = new CustomBuildStrategyBuilder(this);
            }
    
    public N endCustomStrategy(){
            return and();
    }
    public N and(){
            return (N) BuildStrategyFluentImpl.this.withCustomStrategy(builder.build());
    }

}
    public class DockerStrategyNestedImpl<N> extends DockerBuildStrategyFluentImpl<BuildStrategyFluent.DockerStrategyNested<N>> implements BuildStrategyFluent.DockerStrategyNested<N>,Nested<N>{

            private final DockerBuildStrategyBuilder builder;
    
            DockerStrategyNestedImpl(){
                    this.builder = new DockerBuildStrategyBuilder(this);
            }
            DockerStrategyNestedImpl(DockerBuildStrategy item){
                    this.builder = new DockerBuildStrategyBuilder(this, item);
            }
    
    public N and(){
            return (N) BuildStrategyFluentImpl.this.withDockerStrategy(builder.build());
    }
    public N endDockerStrategy(){
            return and();
    }

}
    public class JenkinsPipelineStrategyNestedImpl<N> extends JenkinsPipelineBuildStrategyFluentImpl<BuildStrategyFluent.JenkinsPipelineStrategyNested<N>> implements BuildStrategyFluent.JenkinsPipelineStrategyNested<N>,Nested<N>{

            private final JenkinsPipelineBuildStrategyBuilder builder;
    
            JenkinsPipelineStrategyNestedImpl(JenkinsPipelineBuildStrategy item){
                    this.builder = new JenkinsPipelineBuildStrategyBuilder(this, item);
            }
            JenkinsPipelineStrategyNestedImpl(){
                    this.builder = new JenkinsPipelineBuildStrategyBuilder(this);
            }
    
    public N endJenkinsPipelineStrategy(){
            return and();
    }
    public N and(){
            return (N) BuildStrategyFluentImpl.this.withJenkinsPipelineStrategy(builder.build());
    }

}
    public class SourceStrategyNestedImpl<N> extends SourceBuildStrategyFluentImpl<BuildStrategyFluent.SourceStrategyNested<N>> implements BuildStrategyFluent.SourceStrategyNested<N>,Nested<N>{

            private final SourceBuildStrategyBuilder builder;
    
            SourceStrategyNestedImpl(){
                    this.builder = new SourceBuildStrategyBuilder(this);
            }
            SourceStrategyNestedImpl(SourceBuildStrategy item){
                    this.builder = new SourceBuildStrategyBuilder(this, item);
            }
    
    public N and(){
            return (N) BuildStrategyFluentImpl.this.withSourceStrategy(builder.build());
    }
    public N endSourceStrategy(){
            return and();
    }

}


}
