package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.lang.Integer;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;

public class ScaleFluentImpl<A extends ScaleFluent<A>> extends BaseFluent<A> implements ScaleFluent<A>{

    private String apiVersion;
    private String kind;
    private VisitableBuilder<? extends ObjectMeta,?> metadata;
    private VisitableBuilder<? extends ScaleSpec,?> spec;
    private VisitableBuilder<? extends ScaleStatus,?> status;

    public ScaleFluentImpl(){
    }
    public ScaleFluentImpl(Scale instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata){
            if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public ScaleFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public ScaleFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public ScaleFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public ScaleSpec getSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(ScaleSpec spec){
            if (spec!=null){ this.spec= new ScaleSpecBuilder(spec); _visitables.add(this.spec);} return (A) this;
    }

    public ScaleFluent.SpecNested<A> withNewSpec(){
            return new SpecNestedImpl();
    }

    public ScaleFluent.SpecNested<A> withNewSpecLike(ScaleSpec item){
            return new SpecNestedImpl(item);
    }

    public ScaleFluent.SpecNested<A> editSpec(){
            return withNewSpecLike(getSpec());
    }

    public A withNewSpec(Integer replicas){
            return (A)withSpec(new ScaleSpec(replicas));
    }

    public ScaleStatus getStatus(){
            return this.status!=null?this.status.build():null;
    }

    public A withStatus(ScaleStatus status){
            if (status!=null){ this.status= new ScaleStatusBuilder(status); _visitables.add(this.status);} return (A) this;
    }

    public ScaleFluent.StatusNested<A> withNewStatus(){
            return new StatusNestedImpl();
    }

    public ScaleFluent.StatusNested<A> withNewStatusLike(ScaleStatus item){
            return new StatusNestedImpl(item);
    }

    public ScaleFluent.StatusNested<A> editStatus(){
            return withNewStatusLike(getStatus());
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ScaleFluentImpl that = (ScaleFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
            if (status != null ? !status.equals(that.status) :that.status != null) return false;
            return true;
    }


    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<ScaleFluent.MetadataNested<N>> implements ScaleFluent.MetadataNested<N>,Nested<N>{

            private final ObjectMetaBuilder builder;
    
            MetadataNestedImpl(ObjectMeta item){
                    this.builder = new ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) ScaleFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class SpecNestedImpl<N> extends ScaleSpecFluentImpl<ScaleFluent.SpecNested<N>> implements ScaleFluent.SpecNested<N>,Nested<N>{

            private final ScaleSpecBuilder builder;
    
            SpecNestedImpl(){
                    this.builder = new ScaleSpecBuilder(this);
            }
            SpecNestedImpl(ScaleSpec item){
                    this.builder = new ScaleSpecBuilder(this, item);
            }
    
    public N endSpec(){
            return and();
    }
    public N and(){
            return (N) ScaleFluentImpl.this.withSpec(builder.build());
    }

}
    public class StatusNestedImpl<N> extends ScaleStatusFluentImpl<ScaleFluent.StatusNested<N>> implements ScaleFluent.StatusNested<N>,Nested<N>{

            private final ScaleStatusBuilder builder;
    
            StatusNestedImpl(){
                    this.builder = new ScaleStatusBuilder(this);
            }
            StatusNestedImpl(ScaleStatus item){
                    this.builder = new ScaleStatusBuilder(this, item);
            }
    
    public N and(){
            return (N) ScaleFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus(){
            return and();
    }

}


}
