package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.IntOrString;
import java.lang.String;
import java.lang.Integer;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.IntOrStringFluentImpl;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Override;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;

public class RollingUpdateDeploymentFluentImpl<A extends RollingUpdateDeploymentFluent<A>> extends BaseFluent<A> implements RollingUpdateDeploymentFluent<A>{

    private VisitableBuilder<? extends IntOrString,?> maxSurge;
    private VisitableBuilder<? extends IntOrString,?> maxUnavailable;

    public RollingUpdateDeploymentFluentImpl(){
    }
    public RollingUpdateDeploymentFluentImpl(RollingUpdateDeployment instance){
            this.withMaxSurge(instance.getMaxSurge()); 
            this.withMaxUnavailable(instance.getMaxUnavailable()); 
    }

    public IntOrString getMaxSurge(){
            return this.maxSurge!=null?this.maxSurge.build():null;
    }

    public A withMaxSurge(IntOrString maxSurge){
            if (maxSurge!=null){ this.maxSurge= new IntOrStringBuilder(maxSurge); _visitables.add(this.maxSurge);} return (A) this;
    }

    public RollingUpdateDeploymentFluent.MaxSurgeNested<A> withNewMaxSurge(){
            return new MaxSurgeNestedImpl();
    }

    public RollingUpdateDeploymentFluent.MaxSurgeNested<A> withNewMaxSurgeLike(IntOrString item){
            return new MaxSurgeNestedImpl(item);
    }

    public RollingUpdateDeploymentFluent.MaxSurgeNested<A> editMaxSurge(){
            return withNewMaxSurgeLike(getMaxSurge());
    }

    public A withNewMaxSurge(String strVal){
            return (A)withMaxSurge(new IntOrString(strVal));
    }

    public A withNewMaxSurge(Integer intVal){
            return (A)withMaxSurge(new IntOrString(intVal));
    }

    public IntOrString getMaxUnavailable(){
            return this.maxUnavailable!=null?this.maxUnavailable.build():null;
    }

    public A withMaxUnavailable(IntOrString maxUnavailable){
            if (maxUnavailable!=null){ this.maxUnavailable= new IntOrStringBuilder(maxUnavailable); _visitables.add(this.maxUnavailable);} return (A) this;
    }

    public RollingUpdateDeploymentFluent.MaxUnavailableNested<A> withNewMaxUnavailable(){
            return new MaxUnavailableNestedImpl();
    }

    public RollingUpdateDeploymentFluent.MaxUnavailableNested<A> withNewMaxUnavailableLike(IntOrString item){
            return new MaxUnavailableNestedImpl(item);
    }

    public RollingUpdateDeploymentFluent.MaxUnavailableNested<A> editMaxUnavailable(){
            return withNewMaxUnavailableLike(getMaxUnavailable());
    }

    public A withNewMaxUnavailable(String strVal){
            return (A)withMaxUnavailable(new IntOrString(strVal));
    }

    public A withNewMaxUnavailable(Integer intVal){
            return (A)withMaxUnavailable(new IntOrString(intVal));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RollingUpdateDeploymentFluentImpl that = (RollingUpdateDeploymentFluentImpl) o;
            if (maxSurge != null ? !maxSurge.equals(that.maxSurge) :that.maxSurge != null) return false;
            if (maxUnavailable != null ? !maxUnavailable.equals(that.maxUnavailable) :that.maxUnavailable != null) return false;
            return true;
    }


    public class MaxSurgeNestedImpl<N> extends IntOrStringFluentImpl<RollingUpdateDeploymentFluent.MaxSurgeNested<N>> implements RollingUpdateDeploymentFluent.MaxSurgeNested<N>,Nested<N>{

            private final IntOrStringBuilder builder;
    
            MaxSurgeNestedImpl(){
                    this.builder = new IntOrStringBuilder(this);
            }
            MaxSurgeNestedImpl(IntOrString item){
                    this.builder = new IntOrStringBuilder(this, item);
            }
    
    public N and(){
            return (N) RollingUpdateDeploymentFluentImpl.this.withMaxSurge(builder.build());
    }
    public N endMaxSurge(){
            return and();
    }

}
    public class MaxUnavailableNestedImpl<N> extends IntOrStringFluentImpl<RollingUpdateDeploymentFluent.MaxUnavailableNested<N>> implements RollingUpdateDeploymentFluent.MaxUnavailableNested<N>,Nested<N>{

            private final IntOrStringBuilder builder;
    
            MaxUnavailableNestedImpl(){
                    this.builder = new IntOrStringBuilder(this);
            }
            MaxUnavailableNestedImpl(IntOrString item){
                    this.builder = new IntOrStringBuilder(this, item);
            }
    
    public N endMaxUnavailable(){
            return and();
    }
    public N and(){
            return (N) RollingUpdateDeploymentFluentImpl.this.withMaxUnavailable(builder.build());
    }

}


}
