package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;

public interface JobListFluent<A extends JobListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(Job... items);
    public A removeFromItems(Job... items);
    public List<Job> getItems();
    public A withItems(List<Job> items);
    public A withItems(Job... items);
    public JobListFluent.ItemsNested<A> addNewItem();
    public JobListFluent.ItemsNested<A> addNewItemLike(Job item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public JobListFluent.MetadataNested<A> withNewMetadata();
    public JobListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public JobListFluent.MetadataNested<A> editMetadata();
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,JobFluent<JobListFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<JobListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
