package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.util.List;
import java.util.ArrayList;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class IngressSpecFluentImpl<A extends IngressSpecFluent<A>> extends BaseFluent<A> implements IngressSpecFluent<A>{

    private VisitableBuilder<? extends IngressBackend,?> backend;
    private List<VisitableBuilder<? extends IngressRule,?>> rules =  new ArrayList<VisitableBuilder<? extends IngressRule,?>>();
    private List<VisitableBuilder<? extends IngressTLS,?>> tls =  new ArrayList<VisitableBuilder<? extends IngressTLS,?>>();

    public IngressSpecFluentImpl(){
    }
    public IngressSpecFluentImpl(IngressSpec instance){
            this.withBackend(instance.getBackend()); 
            this.withRules(instance.getRules()); 
            this.withTls(instance.getTls()); 
    }

    public IngressBackend getBackend(){
            return this.backend!=null?this.backend.build():null;
    }

    public A withBackend(IngressBackend backend){
            if (backend!=null){ this.backend= new IngressBackendBuilder(backend); _visitables.add(this.backend);} return (A) this;
    }

    public IngressSpecFluent.BackendNested<A> withNewBackend(){
            return new BackendNestedImpl();
    }

    public IngressSpecFluent.BackendNested<A> withNewBackendLike(IngressBackend item){
            return new BackendNestedImpl(item);
    }

    public IngressSpecFluent.BackendNested<A> editBackend(){
            return withNewBackendLike(getBackend());
    }

    public A addToRules(IngressRule... items){
            for (IngressRule item : items) {IngressRuleBuilder builder = new IngressRuleBuilder(item);_visitables.add(builder);this.rules.add(builder);} return (A)this;
    }

    public A removeFromRules(IngressRule... items){
            for (IngressRule item : items) {IngressRuleBuilder builder = new IngressRuleBuilder(item);_visitables.remove(builder);this.rules.remove(builder);} return (A)this;
    }

    public List<IngressRule> getRules(){
            return build(rules);
    }

    public A withRules(List<IngressRule> rules){
            this.rules.clear();
            if (rules != null) {for (IngressRule item : rules){this.addToRules(item);}} return (A) this;
    }

    public A withRules(IngressRule... rules){
            this.rules.clear(); if (rules != null) {for (IngressRule item :rules){ this.addToRules(item);}} return (A) this;
    }

    public IngressSpecFluent.RulesNested<A> addNewRule(){
            return new RulesNestedImpl();
    }

    public IngressSpecFluent.RulesNested<A> addNewRuleLike(IngressRule item){
            return new RulesNestedImpl(item);
    }

    public A addToTls(IngressTLS... items){
            for (IngressTLS item : items) {IngressTLSBuilder builder = new IngressTLSBuilder(item);_visitables.add(builder);this.tls.add(builder);} return (A)this;
    }

    public A removeFromTls(IngressTLS... items){
            for (IngressTLS item : items) {IngressTLSBuilder builder = new IngressTLSBuilder(item);_visitables.remove(builder);this.tls.remove(builder);} return (A)this;
    }

    public List<IngressTLS> getTls(){
            return build(tls);
    }

    public A withTls(List<IngressTLS> tls){
            this.tls.clear();
            if (tls != null) {for (IngressTLS item : tls){this.addToTls(item);}} return (A) this;
    }

    public A withTls(IngressTLS... tls){
            this.tls.clear(); if (tls != null) {for (IngressTLS item :tls){ this.addToTls(item);}} return (A) this;
    }

    public IngressSpecFluent.TlsNested<A> addNewTl(){
            return new TlsNestedImpl();
    }

    public IngressSpecFluent.TlsNested<A> addNewTlLike(IngressTLS item){
            return new TlsNestedImpl(item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            IngressSpecFluentImpl that = (IngressSpecFluentImpl) o;
            if (backend != null ? !backend.equals(that.backend) :that.backend != null) return false;
            if (rules != null ? !rules.equals(that.rules) :that.rules != null) return false;
            if (tls != null ? !tls.equals(that.tls) :that.tls != null) return false;
            return true;
    }


    public class BackendNestedImpl<N> extends IngressBackendFluentImpl<IngressSpecFluent.BackendNested<N>> implements IngressSpecFluent.BackendNested<N>,Nested<N>{

            private final IngressBackendBuilder builder;
    
            BackendNestedImpl(){
                    this.builder = new IngressBackendBuilder(this);
            }
            BackendNestedImpl(IngressBackend item){
                    this.builder = new IngressBackendBuilder(this, item);
            }
    
    public N and(){
            return (N) IngressSpecFluentImpl.this.withBackend(builder.build());
    }
    public N endBackend(){
            return and();
    }

}
    public class RulesNestedImpl<N> extends IngressRuleFluentImpl<IngressSpecFluent.RulesNested<N>> implements IngressSpecFluent.RulesNested<N>,Nested<N>{

            private final IngressRuleBuilder builder;
    
            RulesNestedImpl(){
                    this.builder = new IngressRuleBuilder(this);
            }
            RulesNestedImpl(IngressRule item){
                    this.builder = new IngressRuleBuilder(this, item);
            }
    
    public N and(){
            return (N) IngressSpecFluentImpl.this.addToRules(builder.build());
    }
    public N endRule(){
            return and();
    }

}
    public class TlsNestedImpl<N> extends IngressTLSFluentImpl<IngressSpecFluent.TlsNested<N>> implements IngressSpecFluent.TlsNested<N>,Nested<N>{

            private final IngressTLSBuilder builder;
    
            TlsNestedImpl(){
                    this.builder = new IngressTLSBuilder(this);
            }
            TlsNestedImpl(IngressTLS item){
                    this.builder = new IngressTLSBuilder(this, item);
            }
    
    public N and(){
            return (N) IngressSpecFluentImpl.this.addToTls(builder.build());
    }
    public N endTl(){
            return and();
    }

}


}
