package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;

public interface IngressListFluent<A extends IngressListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(Ingress... items);
    public A removeFromItems(Ingress... items);
    public List<Ingress> getItems();
    public A withItems(List<Ingress> items);
    public A withItems(Ingress... items);
    public IngressListFluent.ItemsNested<A> addNewItem();
    public IngressListFluent.ItemsNested<A> addNewItemLike(Ingress item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public IngressListFluent.MetadataNested<A> withNewMetadata();
    public IngressListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public IngressListFluent.MetadataNested<A> editMetadata();
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,IngressFluent<IngressListFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<IngressListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
