package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface PersistentVolumeClaimSpecFluent<A extends PersistentVolumeClaimSpecFluent<A>> extends Fluent<A>{


    public A addToAccessModes(String... items);
    public A removeFromAccessModes(String... items);
    public List<String> getAccessModes();
    public A withAccessModes(List<String> accessModes);
    public A withAccessModes(String... accessModes);
    public ResourceRequirements getResources();
    public A withResources(ResourceRequirements resources);
    public PersistentVolumeClaimSpecFluent.ResourcesNested<A> withNewResources();
    public PersistentVolumeClaimSpecFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item);
    public PersistentVolumeClaimSpecFluent.ResourcesNested<A> editResources();
    public LabelSelector getSelector();
    public A withSelector(LabelSelector selector);
    public PersistentVolumeClaimSpecFluent.SelectorNested<A> withNewSelector();
    public PersistentVolumeClaimSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item);
    public PersistentVolumeClaimSpecFluent.SelectorNested<A> editSelector();
    public String getVolumeName();
    public A withVolumeName(String volumeName);

    public interface ResourcesNested<N> extends Nested<N>,ResourceRequirementsFluent<PersistentVolumeClaimSpecFluent.ResourcesNested<N>>{

        
    public N and();    public N endResources();
}
    public interface SelectorNested<N> extends Nested<N>,LabelSelectorFluent<PersistentVolumeClaimSpecFluent.SelectorNested<N>>{

        
    public N endSelector();    public N and();
}


}
