package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface PersistentVolumeClaimFluent<A extends PersistentVolumeClaimFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public PersistentVolumeClaimFluent.MetadataNested<A> withNewMetadata();
    public PersistentVolumeClaimFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public PersistentVolumeClaimFluent.MetadataNested<A> editMetadata();
    public PersistentVolumeClaimSpec getSpec();
    public A withSpec(PersistentVolumeClaimSpec spec);
    public PersistentVolumeClaimFluent.SpecNested<A> withNewSpec();
    public PersistentVolumeClaimFluent.SpecNested<A> withNewSpecLike(PersistentVolumeClaimSpec item);
    public PersistentVolumeClaimFluent.SpecNested<A> editSpec();
    public PersistentVolumeClaimStatus getStatus();
    public A withStatus(PersistentVolumeClaimStatus status);
    public PersistentVolumeClaimFluent.StatusNested<A> withNewStatus();
    public PersistentVolumeClaimFluent.StatusNested<A> withNewStatusLike(PersistentVolumeClaimStatus item);
    public PersistentVolumeClaimFluent.StatusNested<A> editStatus();

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<PersistentVolumeClaimFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,PersistentVolumeClaimSpecFluent<PersistentVolumeClaimFluent.SpecNested<N>>{

        
    public N endSpec();    public N and();
}
    public interface StatusNested<N> extends Nested<N>,PersistentVolumeClaimStatusFluent<PersistentVolumeClaimFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
