package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.Long;
import io.fabric8.kubernetes.api.builder.Nested;

public interface FSGroupStrategyOptionsFluent<A extends FSGroupStrategyOptionsFluent<A>> extends Fluent<A>{


    public A addToRanges(IDRange... items);
    public A removeFromRanges(IDRange... items);
    public List<IDRange> getRanges();
    public A withRanges(List<IDRange> ranges);
    public A withRanges(IDRange... ranges);
    public FSGroupStrategyOptionsFluent.RangesNested<A> addNewRange();
    public FSGroupStrategyOptionsFluent.RangesNested<A> addNewRangeLike(IDRange item);
    public A addNewRange(Long max,Long min);
    public String getType();
    public A withType(String type);

    public interface RangesNested<N> extends Nested<N>,IDRangeFluent<FSGroupStrategyOptionsFluent.RangesNested<N>>{

        
    public N and();    public N endRange();
}


}
