package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.Long;
import java.lang.Boolean;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface DeleteOptionsFluent<A extends DeleteOptionsFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Long getGracePeriodSeconds();
    public A withGracePeriodSeconds(Long gracePeriodSeconds);
    public String getKind();
    public A withKind(String kind);
    public Boolean isOrphanDependents();
    public A withOrphanDependents(Boolean orphanDependents);
    public Preconditions getPreconditions();
    public A withPreconditions(Preconditions preconditions);
    public DeleteOptionsFluent.PreconditionsNested<A> withNewPreconditions();
    public DeleteOptionsFluent.PreconditionsNested<A> withNewPreconditionsLike(Preconditions item);
    public DeleteOptionsFluent.PreconditionsNested<A> editPreconditions();
    public A withNewPreconditions(String uid);

    public interface PreconditionsNested<N> extends Nested<N>,PreconditionsFluent<DeleteOptionsFluent.PreconditionsNested<N>>{

        
    public N and();    public N endPreconditions();
}


}
