package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.Integer;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;

public interface ContainerStateTerminatedFluent<A extends ContainerStateTerminatedFluent<A>> extends Fluent<A>{


    public String getContainerID();
    public A withContainerID(String containerID);
    public Integer getExitCode();
    public A withExitCode(Integer exitCode);
    public String getFinishedAt();
    public A withFinishedAt(String finishedAt);
    public String getMessage();
    public A withMessage(String message);
    public String getReason();
    public A withReason(String reason);
    public Integer getSignal();
    public A withSignal(Integer signal);
    public String getStartedAt();
    public A withStartedAt(String startedAt);



}
