package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.Long;
import java.lang.String;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface DeploymentConfigStatusFluent<A extends DeploymentConfigStatusFluent<A>> extends Fluent<A>{


    public Integer getAvailableReplicas();
    public A withAvailableReplicas(Integer availableReplicas);
    public DeploymentDetails getDetails();
    public A withDetails(DeploymentDetails details);
    public DeploymentConfigStatusFluent.DetailsNested<A> withNewDetails();
    public DeploymentConfigStatusFluent.DetailsNested<A> withNewDetailsLike(DeploymentDetails item);
    public DeploymentConfigStatusFluent.DetailsNested<A> editDetails();
    public Long getLatestVersion();
    public A withLatestVersion(Long latestVersion);
    public Long getObservedGeneration();
    public A withObservedGeneration(Long observedGeneration);
    public Integer getReplicas();
    public A withReplicas(Integer replicas);
    public Integer getUnavailableReplicas();
    public A withUnavailableReplicas(Integer unavailableReplicas);
    public Integer getUpdatedReplicas();
    public A withUpdatedReplicas(Integer updatedReplicas);

    public interface DetailsNested<N> extends Nested<N>,DeploymentDetailsFluent<DeploymentConfigStatusFluent.DetailsNested<N>>{

        
    public N and();    public N endDetails();
}


}
