package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;

public class DeploymentCauseImageTriggerFluentImpl<A extends DeploymentCauseImageTriggerFluent<A>> extends BaseFluent<A> implements DeploymentCauseImageTriggerFluent<A>{

    private VisitableBuilder<? extends ObjectReference,?> from;

    public DeploymentCauseImageTriggerFluentImpl(){
    }
    public DeploymentCauseImageTriggerFluentImpl(DeploymentCauseImageTrigger instance){
            this.withFrom(instance.getFrom()); 
    }

    public ObjectReference getFrom(){
            return this.from!=null?this.from.build():null;
    }

    public A withFrom(ObjectReference from){
            if (from!=null){ this.from= new ObjectReferenceBuilder(from); _visitables.add(this.from);} return (A) this;
    }

    public DeploymentCauseImageTriggerFluent.FromNested<A> withNewFrom(){
            return new FromNestedImpl();
    }

    public DeploymentCauseImageTriggerFluent.FromNested<A> withNewFromLike(ObjectReference item){
            return new FromNestedImpl(item);
    }

    public DeploymentCauseImageTriggerFluent.FromNested<A> editFrom(){
            return withNewFromLike(getFrom());
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DeploymentCauseImageTriggerFluentImpl that = (DeploymentCauseImageTriggerFluentImpl) o;
            if (from != null ? !from.equals(that.from) :that.from != null) return false;
            return true;
    }


    public class FromNestedImpl<N> extends ObjectReferenceFluentImpl<DeploymentCauseImageTriggerFluent.FromNested<N>> implements DeploymentCauseImageTriggerFluent.FromNested<N>,Nested<N>{

            private final ObjectReferenceBuilder builder;
    
            FromNestedImpl(){
                    this.builder = new ObjectReferenceBuilder(this);
            }
            FromNestedImpl(ObjectReference item){
                    this.builder = new ObjectReferenceBuilder(this, item);
            }
    
    public N endFrom(){
            return and();
    }
    public N and(){
            return (N) DeploymentCauseImageTriggerFluentImpl.this.withFrom(builder.build());
    }

}


}
