package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;

public interface ThirdPartyResourceListFluent<A extends ThirdPartyResourceListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(ThirdPartyResource... items);
    public A removeFromItems(ThirdPartyResource... items);
    public List<ThirdPartyResource> getItems();
    public A withItems(List<ThirdPartyResource> items);
    public A withItems(ThirdPartyResource... items);
    public ThirdPartyResourceListFluent.ItemsNested<A> addNewItem();
    public ThirdPartyResourceListFluent.ItemsNested<A> addNewItemLike(ThirdPartyResource item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public ThirdPartyResourceListFluent.MetadataNested<A> withNewMetadata();
    public ThirdPartyResourceListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public ThirdPartyResourceListFluent.MetadataNested<A> editMetadata();
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,ThirdPartyResourceFluent<ThirdPartyResourceListFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<ThirdPartyResourceListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
