package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.String;
import java.util.List;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface JobStatusFluent<A extends JobStatusFluent<A>> extends Fluent<A>{


    public Integer getActive();
    public A withActive(Integer active);
    public String getCompletionTime();
    public A withCompletionTime(String completionTime);
    public A addToConditions(JobCondition... items);
    public A removeFromConditions(JobCondition... items);
    public List<JobCondition> getConditions();
    public A withConditions(List<JobCondition> conditions);
    public A withConditions(JobCondition... conditions);
    public JobStatusFluent.ConditionsNested<A> addNewCondition();
    public JobStatusFluent.ConditionsNested<A> addNewConditionLike(JobCondition item);
    public Integer getFailed();
    public A withFailed(Integer failed);
    public String getStartTime();
    public A withStartTime(String startTime);
    public Integer getSucceeded();
    public A withSucceeded(Integer succeeded);

    public interface ConditionsNested<N> extends Nested<N>,JobConditionFluent<JobStatusFluent.ConditionsNested<N>>{

        
    public N endCondition();    public N and();
}


}
