package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface ResourceQuotaFluent<A extends ResourceQuotaFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public ResourceQuotaFluent.MetadataNested<A> withNewMetadata();
    public ResourceQuotaFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ResourceQuotaFluent.MetadataNested<A> editMetadata();
    public ResourceQuotaSpec getSpec();
    public A withSpec(ResourceQuotaSpec spec);
    public ResourceQuotaFluent.SpecNested<A> withNewSpec();
    public ResourceQuotaFluent.SpecNested<A> withNewSpecLike(ResourceQuotaSpec item);
    public ResourceQuotaFluent.SpecNested<A> editSpec();
    public ResourceQuotaStatus getStatus();
    public A withStatus(ResourceQuotaStatus status);
    public ResourceQuotaFluent.StatusNested<A> withNewStatus();
    public ResourceQuotaFluent.StatusNested<A> withNewStatusLike(ResourceQuotaStatus item);
    public ResourceQuotaFluent.StatusNested<A> editStatus();

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<ResourceQuotaFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,ResourceQuotaSpecFluent<ResourceQuotaFluent.SpecNested<N>>{

        
    public N endSpec();    public N and();
}
    public interface StatusNested<N> extends Nested<N>,ResourceQuotaStatusFluent<ResourceQuotaFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
