package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.util.Set;
import java.lang.Object;

public class ListMetaBuilder extends ListMetaFluentImpl<ListMetaBuilder> implements VisitableBuilder<ListMeta,ListMetaBuilder>{

    ListMetaFluent<?> fluent;
    Boolean validationEnabled;

    public ListMetaBuilder(){
            this(true);
    }
    public ListMetaBuilder(Boolean validationEnabled){
            this(new ListMeta(), validationEnabled);
    }
    public ListMetaBuilder(ListMetaFluent<?> fluent){
            this(fluent, true);
    }
    public ListMetaBuilder(ListMetaFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ListMeta(), validationEnabled);
    }
    public ListMetaBuilder(ListMetaFluent<?> fluent,ListMeta instance){
            this(fluent, instance, true);
    }
    public ListMetaBuilder(ListMetaFluent<?> fluent,ListMeta instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withResourceVersion(instance.getResourceVersion()); 
            fluent.withSelfLink(instance.getSelfLink()); 
            this.validationEnabled = validationEnabled; 
    }
    public ListMetaBuilder(ListMeta instance){
            this(instance,true);
    }
    public ListMetaBuilder(ListMeta instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withResourceVersion(instance.getResourceVersion()); 
            this.withSelfLink(instance.getSelfLink()); 
            this.validationEnabled = validationEnabled; 
    }

    public ListMeta build(){
            ListMeta buildable = new ListMeta(fluent.getResourceVersion(),fluent.getSelfLink());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ListMetaBuilder that = (ListMetaBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
