package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.Integer;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;

public interface ISCSIVolumeSourceFluent<A extends ISCSIVolumeSourceFluent<A>> extends Fluent<A>{


    public String getFsType();
    public A withFsType(String fsType);
    public String getIqn();
    public A withIqn(String iqn);
    public String getIscsiInterface();
    public A withIscsiInterface(String iscsiInterface);
    public Integer getLun();
    public A withLun(Integer lun);
    public Boolean isReadOnly();
    public A withReadOnly(Boolean readOnly);
    public String getTargetPortal();
    public A withTargetPortal(String targetPortal);



}
