package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface DownwardAPIVolumeSourceFluent<A extends DownwardAPIVolumeSourceFluent<A>> extends Fluent<A>{


    public A addToItems(DownwardAPIVolumeFile... items);
    public A removeFromItems(DownwardAPIVolumeFile... items);
    public List<DownwardAPIVolumeFile> getItems();
    public A withItems(List<DownwardAPIVolumeFile> items);
    public A withItems(DownwardAPIVolumeFile... items);
    public DownwardAPIVolumeSourceFluent.ItemsNested<A> addNewItem();
    public DownwardAPIVolumeSourceFluent.ItemsNested<A> addNewItemLike(DownwardAPIVolumeFile item);

    public interface ItemsNested<N> extends Nested<N>,DownwardAPIVolumeFileFluent<DownwardAPIVolumeSourceFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}


}
