package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface GitSourceRevisionFluent<A extends GitSourceRevisionFluent<A>> extends Fluent<A>{


    public SourceControlUser getAuthor();
    public A withAuthor(SourceControlUser author);
    public GitSourceRevisionFluent.AuthorNested<A> withNewAuthor();
    public GitSourceRevisionFluent.AuthorNested<A> withNewAuthorLike(SourceControlUser item);
    public GitSourceRevisionFluent.AuthorNested<A> editAuthor();
    public A withNewAuthor(String email,String name);
    public String getCommit();
    public A withCommit(String commit);
    public SourceControlUser getCommitter();
    public A withCommitter(SourceControlUser committer);
    public GitSourceRevisionFluent.CommitterNested<A> withNewCommitter();
    public GitSourceRevisionFluent.CommitterNested<A> withNewCommitterLike(SourceControlUser item);
    public GitSourceRevisionFluent.CommitterNested<A> editCommitter();
    public A withNewCommitter(String email,String name);
    public String getMessage();
    public A withMessage(String message);

    public interface AuthorNested<N> extends Nested<N>,SourceControlUserFluent<GitSourceRevisionFluent.AuthorNested<N>>{

        
    public N and();    public N endAuthor();
}
    public interface CommitterNested<N> extends Nested<N>,SourceControlUserFluent<GitSourceRevisionFluent.CommitterNested<N>>{

        
    public N and();    public N endCommitter();
}


}
