package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;

public interface DeploymentConfigFluent<A extends DeploymentConfigFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public DeploymentConfigFluent.MetadataNested<A> withNewMetadata();
    public DeploymentConfigFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public DeploymentConfigFluent.MetadataNested<A> editMetadata();
    public DeploymentConfigSpec getSpec();
    public A withSpec(DeploymentConfigSpec spec);
    public DeploymentConfigFluent.SpecNested<A> withNewSpec();
    public DeploymentConfigFluent.SpecNested<A> withNewSpecLike(DeploymentConfigSpec item);
    public DeploymentConfigFluent.SpecNested<A> editSpec();
    public DeploymentConfigStatus getStatus();
    public A withStatus(DeploymentConfigStatus status);
    public DeploymentConfigFluent.StatusNested<A> withNewStatus();
    public DeploymentConfigFluent.StatusNested<A> withNewStatusLike(DeploymentConfigStatus item);
    public DeploymentConfigFluent.StatusNested<A> editStatus();

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<DeploymentConfigFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,DeploymentConfigSpecFluent<DeploymentConfigFluent.SpecNested<N>>{

        
    public N endSpec();    public N and();
}
    public interface StatusNested<N> extends Nested<N>,DeploymentConfigStatusFluent<DeploymentConfigFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
