package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;

public interface ScaleFluent<A extends ScaleFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public ScaleFluent.MetadataNested<A> withNewMetadata();
    public ScaleFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ScaleFluent.MetadataNested<A> editMetadata();
    public ScaleSpec getSpec();
    public A withSpec(ScaleSpec spec);
    public ScaleFluent.SpecNested<A> withNewSpec();
    public ScaleFluent.SpecNested<A> withNewSpecLike(ScaleSpec item);
    public ScaleFluent.SpecNested<A> editSpec();
    public A withNewSpec(Integer replicas);
    public ScaleStatus getStatus();
    public A withStatus(ScaleStatus status);
    public ScaleFluent.StatusNested<A> withNewStatus();
    public ScaleFluent.StatusNested<A> withNewStatusLike(ScaleStatus item);
    public ScaleFluent.StatusNested<A> editStatus();

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<ScaleFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,ScaleSpecFluent<ScaleFluent.SpecNested<N>>{

        
    public N endSpec();    public N and();
}
    public interface StatusNested<N> extends Nested<N>,ScaleStatusFluent<ScaleFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
