package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;

public class ReplicaSetSpecFluentImpl<A extends ReplicaSetSpecFluent<A>> extends BaseFluent<A> implements ReplicaSetSpecFluent<A>{

    private Integer replicas;
    private VisitableBuilder<? extends LabelSelector,?> selector;
    private VisitableBuilder<? extends PodTemplateSpec,?> template;

    public ReplicaSetSpecFluentImpl(){
    }
    public ReplicaSetSpecFluentImpl(ReplicaSetSpec instance){
            this.withReplicas(instance.getReplicas()); 
            this.withSelector(instance.getSelector()); 
            this.withTemplate(instance.getTemplate()); 
    }

    public Integer getReplicas(){
            return this.replicas;
    }

    public A withReplicas(Integer replicas){
            this.replicas=replicas; return (A) this;
    }

    public LabelSelector getSelector(){
            return this.selector!=null?this.selector.build():null;
    }

    public A withSelector(LabelSelector selector){
            if (selector!=null){ this.selector= new LabelSelectorBuilder(selector); _visitables.add(this.selector);} return (A) this;
    }

    public ReplicaSetSpecFluent.SelectorNested<A> withNewSelector(){
            return new SelectorNestedImpl();
    }

    public ReplicaSetSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item){
            return new SelectorNestedImpl(item);
    }

    public ReplicaSetSpecFluent.SelectorNested<A> editSelector(){
            return withNewSelectorLike(getSelector());
    }

    public PodTemplateSpec getTemplate(){
            return this.template!=null?this.template.build():null;
    }

    public A withTemplate(PodTemplateSpec template){
            if (template!=null){ this.template= new PodTemplateSpecBuilder(template); _visitables.add(this.template);} return (A) this;
    }

    public ReplicaSetSpecFluent.TemplateNested<A> withNewTemplate(){
            return new TemplateNestedImpl();
    }

    public ReplicaSetSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item){
            return new TemplateNestedImpl(item);
    }

    public ReplicaSetSpecFluent.TemplateNested<A> editTemplate(){
            return withNewTemplateLike(getTemplate());
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ReplicaSetSpecFluentImpl that = (ReplicaSetSpecFluentImpl) o;
            if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
            if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
            if (template != null ? !template.equals(that.template) :that.template != null) return false;
            return true;
    }


    public class SelectorNestedImpl<N> extends LabelSelectorFluentImpl<ReplicaSetSpecFluent.SelectorNested<N>> implements ReplicaSetSpecFluent.SelectorNested<N>,Nested<N>{

            private final LabelSelectorBuilder builder;
    
            SelectorNestedImpl(){
                    this.builder = new LabelSelectorBuilder(this);
            }
            SelectorNestedImpl(LabelSelector item){
                    this.builder = new LabelSelectorBuilder(this, item);
            }
    
    public N endSelector(){
            return and();
    }
    public N and(){
            return (N) ReplicaSetSpecFluentImpl.this.withSelector(builder.build());
    }

}
    public class TemplateNestedImpl<N> extends PodTemplateSpecFluentImpl<ReplicaSetSpecFluent.TemplateNested<N>> implements ReplicaSetSpecFluent.TemplateNested<N>,Nested<N>{

            private final PodTemplateSpecBuilder builder;
    
            TemplateNestedImpl(){
                    this.builder = new PodTemplateSpecBuilder(this);
            }
            TemplateNestedImpl(PodTemplateSpec item){
                    this.builder = new PodTemplateSpecBuilder(this, item);
            }
    
    public N endTemplate(){
            return and();
    }
    public N and(){
            return (N) ReplicaSetSpecFluentImpl.this.withTemplate(builder.build());
    }

}


}
