package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;

public interface ReplicaSetListFluent<A extends ReplicaSetListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(ReplicaSet... items);
    public A removeFromItems(ReplicaSet... items);
    public List<ReplicaSet> getItems();
    public A withItems(List<ReplicaSet> items);
    public A withItems(ReplicaSet... items);
    public ReplicaSetListFluent.ItemsNested<A> addNewItem();
    public ReplicaSetListFluent.ItemsNested<A> addNewItemLike(ReplicaSet item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public ReplicaSetListFluent.MetadataNested<A> withNewMetadata();
    public ReplicaSetListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public ReplicaSetListFluent.MetadataNested<A> editMetadata();
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,ReplicaSetFluent<ReplicaSetListFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<ReplicaSetListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
