package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;

public interface JobFluent<A extends JobFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public JobFluent.MetadataNested<A> withNewMetadata();
    public JobFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public JobFluent.MetadataNested<A> editMetadata();
    public JobSpec getSpec();
    public A withSpec(JobSpec spec);
    public JobFluent.SpecNested<A> withNewSpec();
    public JobFluent.SpecNested<A> withNewSpecLike(JobSpec item);
    public JobFluent.SpecNested<A> editSpec();
    public JobStatus getStatus();
    public A withStatus(JobStatus status);
    public JobFluent.StatusNested<A> withNewStatus();
    public JobFluent.StatusNested<A> withNewStatusLike(JobStatus item);
    public JobFluent.StatusNested<A> editStatus();

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<JobFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,JobSpecFluent<JobFluent.SpecNested<N>>{

        
    public N endSpec();    public N and();
}
    public interface StatusNested<N> extends Nested<N>,JobStatusFluent<JobFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
