package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.util.List;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonIgnore;

public interface ResourceQuotaSpecFluent<A extends ResourceQuotaSpecFluent<A>> extends Fluent<A>{


    public A addToHard(String key,Quantity value);
    public A addToHard(Map<String,Quantity> map);
    public A removeFromHard(String key);
    public A removeFromHard(Map<String,Quantity> map);
    public Map<String,Quantity> getHard();
    public A withHard(Map<String,Quantity> hard);
    public A addToScopes(String... items);
    public A removeFromScopes(String... items);
    public List<String> getScopes();
    public A withScopes(List<String> scopes);
    public A withScopes(String... scopes);



}
