package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Long;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface PodSpecFluent<A extends PodSpecFluent<A>> extends Fluent<A>{


    public Long getActiveDeadlineSeconds();
    public A withActiveDeadlineSeconds(Long activeDeadlineSeconds);
    public A addToContainers(Container... items);
    public A removeFromContainers(Container... items);
    public List<Container> getContainers();
    public A withContainers(List<Container> containers);
    public A withContainers(Container... containers);
    public PodSpecFluent.ContainersNested<A> addNewContainer();
    public PodSpecFluent.ContainersNested<A> addNewContainerLike(Container item);
    public String getDnsPolicy();
    public A withDnsPolicy(String dnsPolicy);
    public String getHost();
    public A withHost(String host);
    public Boolean isHostIPC();
    public A withHostIPC(Boolean hostIPC);
    public Boolean isHostNetwork();
    public A withHostNetwork(Boolean hostNetwork);
    public Boolean isHostPID();
    public A withHostPID(Boolean hostPID);
    public String getHostname();
    public A withHostname(String hostname);
    public A addToImagePullSecrets(LocalObjectReference... items);
    public A removeFromImagePullSecrets(LocalObjectReference... items);
    public List<LocalObjectReference> getImagePullSecrets();
    public A withImagePullSecrets(List<LocalObjectReference> imagePullSecrets);
    public A withImagePullSecrets(LocalObjectReference... imagePullSecrets);
    public PodSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecret();
    public PodSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecretLike(LocalObjectReference item);
    public A addNewImagePullSecret(String name);
    public String getNodeName();
    public A withNodeName(String nodeName);
    public A addToNodeSelector(String key,String value);
    public A addToNodeSelector(Map<String,String> map);
    public A removeFromNodeSelector(String key);
    public A removeFromNodeSelector(Map<String,String> map);
    public Map<String,String> getNodeSelector();
    public A withNodeSelector(Map<String,String> nodeSelector);
    public String getRestartPolicy();
    public A withRestartPolicy(String restartPolicy);
    public PodSecurityContext getSecurityContext();
    public A withSecurityContext(PodSecurityContext securityContext);
    public PodSpecFluent.SecurityContextNested<A> withNewSecurityContext();
    public PodSpecFluent.SecurityContextNested<A> withNewSecurityContextLike(PodSecurityContext item);
    public PodSpecFluent.SecurityContextNested<A> editSecurityContext();
    public String getServiceAccount();
    public A withServiceAccount(String serviceAccount);
    public String getServiceAccountName();
    public A withServiceAccountName(String serviceAccountName);
    public String getSubdomain();
    public A withSubdomain(String subdomain);
    public Long getTerminationGracePeriodSeconds();
    public A withTerminationGracePeriodSeconds(Long terminationGracePeriodSeconds);
    public A addToVolumes(Volume... items);
    public A removeFromVolumes(Volume... items);
    public List<Volume> getVolumes();
    public A withVolumes(List<Volume> volumes);
    public A withVolumes(Volume... volumes);
    public PodSpecFluent.VolumesNested<A> addNewVolume();
    public PodSpecFluent.VolumesNested<A> addNewVolumeLike(Volume item);

    public interface ContainersNested<N> extends Nested<N>,ContainerFluent<PodSpecFluent.ContainersNested<N>>{

        
    public N and();    public N endContainer();
}
    public interface ImagePullSecretsNested<N> extends Nested<N>,LocalObjectReferenceFluent<PodSpecFluent.ImagePullSecretsNested<N>>{

        
    public N and();    public N endImagePullSecret();
}
    public interface SecurityContextNested<N> extends Nested<N>,PodSecurityContextFluent<PodSpecFluent.SecurityContextNested<N>>{

        
    public N and();    public N endSecurityContext();
}
    public interface VolumesNested<N> extends Nested<N>,VolumeFluent<PodSpecFluent.VolumesNested<N>>{

        
    public N and();    public N endVolume();
}


}
