package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Nested;

public interface NodeFluent<A extends NodeFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public NodeFluent.MetadataNested<A> withNewMetadata();
    public NodeFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public NodeFluent.MetadataNested<A> editMetadata();
    public NodeSpec getSpec();
    public A withSpec(NodeSpec spec);
    public NodeFluent.SpecNested<A> withNewSpec();
    public NodeFluent.SpecNested<A> withNewSpecLike(NodeSpec item);
    public NodeFluent.SpecNested<A> editSpec();
    public A withNewSpec(String externalID,String podCIDR,String providerID,Boolean unschedulable);
    public NodeStatus getStatus();
    public A withStatus(NodeStatus status);
    public NodeFluent.StatusNested<A> withNewStatus();
    public NodeFluent.StatusNested<A> withNewStatusLike(NodeStatus item);
    public NodeFluent.StatusNested<A> editStatus();

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<NodeFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,NodeSpecFluent<NodeFluent.SpecNested<N>>{

        
    public N endSpec();    public N and();
}
    public interface StatusNested<N> extends Nested<N>,NodeStatusFluent<NodeFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
