package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface NamedClusterFluent<A extends NamedClusterFluent<A>> extends Fluent<A>{


    public Cluster getCluster();
    public A withCluster(Cluster cluster);
    public NamedClusterFluent.ClusterNested<A> withNewCluster();
    public NamedClusterFluent.ClusterNested<A> withNewClusterLike(Cluster item);
    public NamedClusterFluent.ClusterNested<A> editCluster();
    public String getName();
    public A withName(String name);

    public interface ClusterNested<N> extends Nested<N>,ClusterFluent<NamedClusterFluent.ClusterNested<N>>{

        
    public N endCluster();    public N and();
}


}
