package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface NamedAuthInfoFluent<A extends NamedAuthInfoFluent<A>> extends Fluent<A>{


    public String getName();
    public A withName(String name);
    public AuthInfo getUser();
    public A withUser(AuthInfo user);
    public NamedAuthInfoFluent.UserNested<A> withNewUser();
    public NamedAuthInfoFluent.UserNested<A> withNewUserLike(AuthInfo item);
    public NamedAuthInfoFluent.UserNested<A> editUser();

    public interface UserNested<N> extends Nested<N>,AuthInfoFluent<NamedAuthInfoFluent.UserNested<N>>{

        
    public N and();    public N endUser();
}


}
