package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.Object;

public class IDRangeFluentImpl<A extends IDRangeFluent<A>> extends BaseFluent<A> implements IDRangeFluent<A>{

    private Long max;
    private Long min;

    public IDRangeFluentImpl(){
    }
    public IDRangeFluentImpl(IDRange instance){
            this.withMax(instance.getMax()); 
            this.withMin(instance.getMin()); 
    }

    public Long getMax(){
            return this.max;
    }

    public A withMax(Long max){
            this.max=max; return (A) this;
    }

    public Long getMin(){
            return this.min;
    }

    public A withMin(Long min){
            this.min=min; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            IDRangeFluentImpl that = (IDRangeFluentImpl) o;
            if (max != null ? !max.equals(that.max) :that.max != null) return false;
            if (min != null ? !min.equals(that.min) :that.min != null) return false;
            return true;
    }




}
