package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.util.Set;
import java.lang.Object;

public class FCVolumeSourceBuilder extends FCVolumeSourceFluentImpl<FCVolumeSourceBuilder> implements VisitableBuilder<FCVolumeSource,FCVolumeSourceBuilder>{

    FCVolumeSourceFluent<?> fluent;
    Boolean validationEnabled;

    public FCVolumeSourceBuilder(){
            this(true);
    }
    public FCVolumeSourceBuilder(Boolean validationEnabled){
            this(new FCVolumeSource(), validationEnabled);
    }
    public FCVolumeSourceBuilder(FCVolumeSourceFluent<?> fluent){
            this(fluent, true);
    }
    public FCVolumeSourceBuilder(FCVolumeSourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new FCVolumeSource(), validationEnabled);
    }
    public FCVolumeSourceBuilder(FCVolumeSourceFluent<?> fluent,FCVolumeSource instance){
            this(fluent, instance, true);
    }
    public FCVolumeSourceBuilder(FCVolumeSourceFluent<?> fluent,FCVolumeSource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withFsType(instance.getFsType()); 
            fluent.withLun(instance.getLun()); 
            fluent.withReadOnly(instance.getReadOnly()); 
            fluent.withTargetWWNs(instance.getTargetWWNs()); 
            this.validationEnabled = validationEnabled; 
    }
    public FCVolumeSourceBuilder(FCVolumeSource instance){
            this(instance,true);
    }
    public FCVolumeSourceBuilder(FCVolumeSource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withFsType(instance.getFsType()); 
            this.withLun(instance.getLun()); 
            this.withReadOnly(instance.getReadOnly()); 
            this.withTargetWWNs(instance.getTargetWWNs()); 
            this.validationEnabled = validationEnabled; 
    }

    public FCVolumeSource build(){
            FCVolumeSource buildable = new FCVolumeSource(fluent.getFsType(),fluent.getLun(),fluent.isReadOnly(),fluent.getTargetWWNs());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            FCVolumeSourceBuilder that = (FCVolumeSourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
