package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.List;
import javax.validation.Valid;
import java.util.ArrayList;
import javax.validation.constraints.NotNull;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class ConfigFluentImpl<A extends ConfigFluent<A>> extends BaseFluent<A> implements ConfigFluent<A>{

    private String apiVersion;
    private List<VisitableBuilder<? extends NamedCluster,?>> clusters =  new ArrayList<VisitableBuilder<? extends NamedCluster,?>>();
    private List<VisitableBuilder<? extends NamedContext,?>> contexts =  new ArrayList<VisitableBuilder<? extends NamedContext,?>>();
    private String currentContext;
    private List<VisitableBuilder<? extends NamedExtension,?>> extensions =  new ArrayList<VisitableBuilder<? extends NamedExtension,?>>();
    private String kind;
    private VisitableBuilder<? extends Preferences,?> preferences;
    private List<VisitableBuilder<? extends NamedAuthInfo,?>> users =  new ArrayList<VisitableBuilder<? extends NamedAuthInfo,?>>();

    public ConfigFluentImpl(){
    }
    public ConfigFluentImpl(Config instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withClusters(instance.getClusters()); 
            this.withContexts(instance.getContexts()); 
            this.withCurrentContext(instance.getCurrentContext()); 
            this.withExtensions(instance.getExtensions()); 
            this.withKind(instance.getKind()); 
            this.withPreferences(instance.getPreferences()); 
            this.withUsers(instance.getUsers()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public A addToClusters(NamedCluster... items){
            for (NamedCluster item : items) {NamedClusterBuilder builder = new NamedClusterBuilder(item);_visitables.add(builder);this.clusters.add(builder);} return (A)this;
    }

    public A removeFromClusters(NamedCluster... items){
            for (NamedCluster item : items) {NamedClusterBuilder builder = new NamedClusterBuilder(item);_visitables.remove(builder);this.clusters.remove(builder);} return (A)this;
    }

    public List<NamedCluster> getClusters(){
            return build(clusters);
    }

    public A withClusters(List<NamedCluster> clusters){
            this.clusters.clear();
            if (clusters != null) {for (NamedCluster item : clusters){this.addToClusters(item);}} return (A) this;
    }

    public A withClusters(NamedCluster... clusters){
            this.clusters.clear(); if (clusters != null) {for (NamedCluster item :clusters){ this.addToClusters(item);}} return (A) this;
    }

    public ConfigFluent.ClustersNested<A> addNewCluster(){
            return new ClustersNestedImpl();
    }

    public ConfigFluent.ClustersNested<A> addNewClusterLike(NamedCluster item){
            return new ClustersNestedImpl(item);
    }

    public A addToContexts(NamedContext... items){
            for (NamedContext item : items) {NamedContextBuilder builder = new NamedContextBuilder(item);_visitables.add(builder);this.contexts.add(builder);} return (A)this;
    }

    public A removeFromContexts(NamedContext... items){
            for (NamedContext item : items) {NamedContextBuilder builder = new NamedContextBuilder(item);_visitables.remove(builder);this.contexts.remove(builder);} return (A)this;
    }

    public List<NamedContext> getContexts(){
            return build(contexts);
    }

    public A withContexts(List<NamedContext> contexts){
            this.contexts.clear();
            if (contexts != null) {for (NamedContext item : contexts){this.addToContexts(item);}} return (A) this;
    }

    public A withContexts(NamedContext... contexts){
            this.contexts.clear(); if (contexts != null) {for (NamedContext item :contexts){ this.addToContexts(item);}} return (A) this;
    }

    public ConfigFluent.ContextsNested<A> addNewContext(){
            return new ContextsNestedImpl();
    }

    public ConfigFluent.ContextsNested<A> addNewContextLike(NamedContext item){
            return new ContextsNestedImpl(item);
    }

    public String getCurrentContext(){
            return this.currentContext;
    }

    public A withCurrentContext(String currentContext){
            this.currentContext=currentContext; return (A) this;
    }

    public A addToExtensions(NamedExtension... items){
            for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.add(builder);this.extensions.add(builder);} return (A)this;
    }

    public A removeFromExtensions(NamedExtension... items){
            for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.remove(builder);this.extensions.remove(builder);} return (A)this;
    }

    public List<NamedExtension> getExtensions(){
            return build(extensions);
    }

    public A withExtensions(List<NamedExtension> extensions){
            this.extensions.clear();
            if (extensions != null) {for (NamedExtension item : extensions){this.addToExtensions(item);}} return (A) this;
    }

    public A withExtensions(NamedExtension... extensions){
            this.extensions.clear(); if (extensions != null) {for (NamedExtension item :extensions){ this.addToExtensions(item);}} return (A) this;
    }

    public ConfigFluent.ExtensionsNested<A> addNewExtension(){
            return new ExtensionsNestedImpl();
    }

    public ConfigFluent.ExtensionsNested<A> addNewExtensionLike(NamedExtension item){
            return new ExtensionsNestedImpl(item);
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Preferences getPreferences(){
            return this.preferences!=null?this.preferences.build():null;
    }

    public A withPreferences(Preferences preferences){
            if (preferences!=null){ this.preferences= new PreferencesBuilder(preferences); _visitables.add(this.preferences);} return (A) this;
    }

    public ConfigFluent.PreferencesNested<A> withNewPreferences(){
            return new PreferencesNestedImpl();
    }

    public ConfigFluent.PreferencesNested<A> withNewPreferencesLike(Preferences item){
            return new PreferencesNestedImpl(item);
    }

    public ConfigFluent.PreferencesNested<A> editPreferences(){
            return withNewPreferencesLike(getPreferences());
    }

    public A addToUsers(NamedAuthInfo... items){
            for (NamedAuthInfo item : items) {NamedAuthInfoBuilder builder = new NamedAuthInfoBuilder(item);_visitables.add(builder);this.users.add(builder);} return (A)this;
    }

    public A removeFromUsers(NamedAuthInfo... items){
            for (NamedAuthInfo item : items) {NamedAuthInfoBuilder builder = new NamedAuthInfoBuilder(item);_visitables.remove(builder);this.users.remove(builder);} return (A)this;
    }

    public List<NamedAuthInfo> getUsers(){
            return build(users);
    }

    public A withUsers(List<NamedAuthInfo> users){
            this.users.clear();
            if (users != null) {for (NamedAuthInfo item : users){this.addToUsers(item);}} return (A) this;
    }

    public A withUsers(NamedAuthInfo... users){
            this.users.clear(); if (users != null) {for (NamedAuthInfo item :users){ this.addToUsers(item);}} return (A) this;
    }

    public ConfigFluent.UsersNested<A> addNewUser(){
            return new UsersNestedImpl();
    }

    public ConfigFluent.UsersNested<A> addNewUserLike(NamedAuthInfo item){
            return new UsersNestedImpl(item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ConfigFluentImpl that = (ConfigFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (clusters != null ? !clusters.equals(that.clusters) :that.clusters != null) return false;
            if (contexts != null ? !contexts.equals(that.contexts) :that.contexts != null) return false;
            if (currentContext != null ? !currentContext.equals(that.currentContext) :that.currentContext != null) return false;
            if (extensions != null ? !extensions.equals(that.extensions) :that.extensions != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (preferences != null ? !preferences.equals(that.preferences) :that.preferences != null) return false;
            if (users != null ? !users.equals(that.users) :that.users != null) return false;
            return true;
    }


    public class ClustersNestedImpl<N> extends NamedClusterFluentImpl<ConfigFluent.ClustersNested<N>> implements ConfigFluent.ClustersNested<N>,Nested<N>{

            private final NamedClusterBuilder builder;
    
            ClustersNestedImpl(){
                    this.builder = new NamedClusterBuilder(this);
            }
            ClustersNestedImpl(NamedCluster item){
                    this.builder = new NamedClusterBuilder(this, item);
            }
    
    public N endCluster(){
            return and();
    }
    public N and(){
            return (N) ConfigFluentImpl.this.addToClusters(builder.build());
    }

}
    public class ContextsNestedImpl<N> extends NamedContextFluentImpl<ConfigFluent.ContextsNested<N>> implements ConfigFluent.ContextsNested<N>,Nested<N>{

            private final NamedContextBuilder builder;
    
            ContextsNestedImpl(){
                    this.builder = new NamedContextBuilder(this);
            }
            ContextsNestedImpl(NamedContext item){
                    this.builder = new NamedContextBuilder(this, item);
            }
    
    public N endContext(){
            return and();
    }
    public N and(){
            return (N) ConfigFluentImpl.this.addToContexts(builder.build());
    }

}
    public class ExtensionsNestedImpl<N> extends NamedExtensionFluentImpl<ConfigFluent.ExtensionsNested<N>> implements ConfigFluent.ExtensionsNested<N>,Nested<N>{

            private final NamedExtensionBuilder builder;
    
            ExtensionsNestedImpl(){
                    this.builder = new NamedExtensionBuilder(this);
            }
            ExtensionsNestedImpl(NamedExtension item){
                    this.builder = new NamedExtensionBuilder(this, item);
            }
    
    public N and(){
            return (N) ConfigFluentImpl.this.addToExtensions(builder.build());
    }
    public N endExtension(){
            return and();
    }

}
    public class PreferencesNestedImpl<N> extends PreferencesFluentImpl<ConfigFluent.PreferencesNested<N>> implements ConfigFluent.PreferencesNested<N>,Nested<N>{

            private final PreferencesBuilder builder;
    
            PreferencesNestedImpl(){
                    this.builder = new PreferencesBuilder(this);
            }
            PreferencesNestedImpl(Preferences item){
                    this.builder = new PreferencesBuilder(this, item);
            }
    
    public N and(){
            return (N) ConfigFluentImpl.this.withPreferences(builder.build());
    }
    public N endPreferences(){
            return and();
    }

}
    public class UsersNestedImpl<N> extends NamedAuthInfoFluentImpl<ConfigFluent.UsersNested<N>> implements ConfigFluent.UsersNested<N>,Nested<N>{

            private final NamedAuthInfoBuilder builder;
    
            UsersNestedImpl(){
                    this.builder = new NamedAuthInfoBuilder(this);
            }
            UsersNestedImpl(NamedAuthInfo item){
                    this.builder = new NamedAuthInfoBuilder(this, item);
            }
    
    public N and(){
            return (N) ConfigFluentImpl.this.addToUsers(builder.build());
    }
    public N endUser(){
            return and();
    }

}


}
