/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.ContainerStatusBuilder;
import io.fabric8.kubernetes.api.model.ContainerStatusFluentImpl;
import io.fabric8.kubernetes.api.model.PodCondition;
import io.fabric8.kubernetes.api.model.PodConditionBuilder;
import io.fabric8.kubernetes.api.model.PodConditionFluentImpl;
import io.fabric8.kubernetes.api.model.PodStatus;
import io.fabric8.kubernetes.api.model.PodStatusFluent;
import java.util.ArrayList;
import java.util.List;

public class PodStatusFluentImpl<A extends PodStatusFluent<A>>
extends BaseFluent<A>
implements PodStatusFluent<A> {
    private List<VisitableBuilder<? extends ContainerStatus, ?>> initContainerStatuses = new ArrayList();
    private List<VisitableBuilder<? extends PodCondition, ?>> conditions = new ArrayList();
    private List<VisitableBuilder<? extends ContainerStatus, ?>> containerStatuses = new ArrayList();
    private String hostIP;
    private String message;
    private String phase;
    private String podIP;
    private String reason;
    private String startTime;

    public PodStatusFluentImpl() {
    }

    public PodStatusFluentImpl(PodStatus instance) {
        this.withInitContainerStatuses(instance.getInitContainerStatuses());
        this.withConditions(instance.getConditions());
        this.withContainerStatuses(instance.getContainerStatuses());
        this.withHostIP(instance.getHostIP());
        this.withMessage(instance.getMessage());
        this.withPhase(instance.getPhase());
        this.withPodIP(instance.getPodIP());
        this.withReason(instance.getReason());
        this.withStartTime(instance.getStartTime());
    }

    @Override
    public A addToInitContainerStatuses(ContainerStatus ... items) {
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.add(builder);
            this.initContainerStatuses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromInitContainerStatuses(ContainerStatus ... items) {
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.remove(builder);
            this.initContainerStatuses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<ContainerStatus> getInitContainerStatuses() {
        return PodStatusFluentImpl.build(this.initContainerStatuses);
    }

    @Override
    public A withInitContainerStatuses(List<ContainerStatus> initContainerStatuses) {
        this.initContainerStatuses.clear();
        if (initContainerStatuses != null) {
            for (ContainerStatus item : initContainerStatuses) {
                this.addToInitContainerStatuses(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withInitContainerStatuses(ContainerStatus ... initContainerStatuses) {
        this.initContainerStatuses.clear();
        if (initContainerStatuses != null) {
            for (ContainerStatus item : initContainerStatuses) {
                this.addToInitContainerStatuses(item);
            }
        }
        return (A)this;
    }

    @Override
    public PodStatusFluent.InitContainerStatusesNested<A> addNewInitContainerStatus() {
        return new InitContainerStatusesNestedImpl();
    }

    @Override
    public PodStatusFluent.InitContainerStatusesNested<A> addNewInitContainerStatusLike(ContainerStatus item) {
        return new InitContainerStatusesNestedImpl(item);
    }

    @Override
    public A addToConditions(PodCondition ... items) {
        for (PodCondition item : items) {
            PodConditionBuilder builder = new PodConditionBuilder(item);
            this._visitables.add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(PodCondition ... items) {
        for (PodCondition item : items) {
            PodConditionBuilder builder = new PodConditionBuilder(item);
            this._visitables.remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<PodCondition> getConditions() {
        return PodStatusFluentImpl.build(this.conditions);
    }

    @Override
    public A withConditions(List<PodCondition> conditions) {
        this.conditions.clear();
        if (conditions != null) {
            for (PodCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withConditions(PodCondition ... conditions) {
        this.conditions.clear();
        if (conditions != null) {
            for (PodCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public PodStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public PodStatusFluent.ConditionsNested<A> addNewConditionLike(PodCondition item) {
        return new ConditionsNestedImpl(item);
    }

    @Override
    public A addToContainerStatuses(ContainerStatus ... items) {
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.add(builder);
            this.containerStatuses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromContainerStatuses(ContainerStatus ... items) {
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.remove(builder);
            this.containerStatuses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<ContainerStatus> getContainerStatuses() {
        return PodStatusFluentImpl.build(this.containerStatuses);
    }

    @Override
    public A withContainerStatuses(List<ContainerStatus> containerStatuses) {
        this.containerStatuses.clear();
        if (containerStatuses != null) {
            for (ContainerStatus item : containerStatuses) {
                this.addToContainerStatuses(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withContainerStatuses(ContainerStatus ... containerStatuses) {
        this.containerStatuses.clear();
        if (containerStatuses != null) {
            for (ContainerStatus item : containerStatuses) {
                this.addToContainerStatuses(item);
            }
        }
        return (A)this;
    }

    @Override
    public PodStatusFluent.ContainerStatusesNested<A> addNewContainerStatus() {
        return new ContainerStatusesNestedImpl();
    }

    @Override
    public PodStatusFluent.ContainerStatusesNested<A> addNewContainerStatusLike(ContainerStatus item) {
        return new ContainerStatusesNestedImpl(item);
    }

    @Override
    public String getHostIP() {
        return this.hostIP;
    }

    @Override
    public A withHostIP(String hostIP) {
        this.hostIP = hostIP;
        return (A)this;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public A withMessage(String message) {
        this.message = message;
        return (A)this;
    }

    @Override
    public String getPhase() {
        return this.phase;
    }

    @Override
    public A withPhase(String phase) {
        this.phase = phase;
        return (A)this;
    }

    @Override
    public String getPodIP() {
        return this.podIP;
    }

    @Override
    public A withPodIP(String podIP) {
        this.podIP = podIP;
        return (A)this;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public A withReason(String reason) {
        this.reason = reason;
        return (A)this;
    }

    @Override
    public String getStartTime() {
        return this.startTime;
    }

    @Override
    public A withStartTime(String startTime) {
        this.startTime = startTime;
        return (A)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodStatusFluentImpl that = (PodStatusFluentImpl)o;
        if (this.initContainerStatuses != null ? !this.initContainerStatuses.equals(that.initContainerStatuses) : that.initContainerStatuses != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.containerStatuses != null ? !this.containerStatuses.equals(that.containerStatuses) : that.containerStatuses != null) {
            return false;
        }
        if (this.hostIP != null ? !this.hostIP.equals(that.hostIP) : that.hostIP != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        if (this.phase != null ? !this.phase.equals(that.phase) : that.phase != null) {
            return false;
        }
        if (this.podIP != null ? !this.podIP.equals(that.podIP) : that.podIP != null) {
            return false;
        }
        if (this.reason != null ? !this.reason.equals(that.reason) : that.reason != null) {
            return false;
        }
        return !(this.startTime != null ? !this.startTime.equals(that.startTime) : that.startTime != null);
    }

    public class ContainerStatusesNestedImpl<N>
    extends ContainerStatusFluentImpl<PodStatusFluent.ContainerStatusesNested<N>>
    implements PodStatusFluent.ContainerStatusesNested<N>,
    Nested<N> {
        private final ContainerStatusBuilder builder;

        ContainerStatusesNestedImpl(ContainerStatus item) {
            this.builder = new ContainerStatusBuilder(this, item);
        }

        ContainerStatusesNestedImpl() {
            this.builder = new ContainerStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodStatusFluentImpl.this.addToContainerStatuses(this.builder.build());
        }

        @Override
        public N endContainerStatus() {
            return this.and();
        }
    }

    public class ConditionsNestedImpl<N>
    extends PodConditionFluentImpl<PodStatusFluent.ConditionsNested<N>>
    implements PodStatusFluent.ConditionsNested<N>,
    Nested<N> {
        private final PodConditionBuilder builder;

        ConditionsNestedImpl() {
            this.builder = new PodConditionBuilder(this);
        }

        ConditionsNestedImpl(PodCondition item) {
            this.builder = new PodConditionBuilder(this, item);
        }

        @Override
        public N endCondition() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)PodStatusFluentImpl.this.addToConditions(this.builder.build());
        }
    }

    public class InitContainerStatusesNestedImpl<N>
    extends ContainerStatusFluentImpl<PodStatusFluent.InitContainerStatusesNested<N>>
    implements PodStatusFluent.InitContainerStatusesNested<N>,
    Nested<N> {
        private final ContainerStatusBuilder builder;

        InitContainerStatusesNestedImpl(ContainerStatus item) {
            this.builder = new ContainerStatusBuilder(this, item);
        }

        InitContainerStatusesNestedImpl() {
            this.builder = new ContainerStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodStatusFluentImpl.this.addToInitContainerStatuses(this.builder.build());
        }

        @Override
        public N endInitContainerStatus() {
            return this.and();
        }
    }
}

