package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.lang.String;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;

public interface SourceBuildStrategyFluent<A extends SourceBuildStrategyFluent<A>> extends Fluent<A>{


    public A addToEnv(EnvVar... items);
    public A removeFromEnv(EnvVar... items);
    public List<EnvVar> getEnv();
    public A withEnv(List<EnvVar> env);
    public A withEnv(EnvVar... env);
    public SourceBuildStrategyFluent.EnvNested<A> addNewEnv();
    public SourceBuildStrategyFluent.EnvNested<A> addNewEnvLike(EnvVar item);
    public Boolean isForcePull();
    public A withForcePull(Boolean forcePull);
    public ObjectReference getFrom();
    public A withFrom(ObjectReference from);
    public SourceBuildStrategyFluent.FromNested<A> withNewFrom();
    public SourceBuildStrategyFluent.FromNested<A> withNewFromLike(ObjectReference item);
    public SourceBuildStrategyFluent.FromNested<A> editFrom();
    public Boolean isIncremental();
    public A withIncremental(Boolean incremental);
    public LocalObjectReference getPullSecret();
    public A withPullSecret(LocalObjectReference pullSecret);
    public SourceBuildStrategyFluent.PullSecretNested<A> withNewPullSecret();
    public SourceBuildStrategyFluent.PullSecretNested<A> withNewPullSecretLike(LocalObjectReference item);
    public SourceBuildStrategyFluent.PullSecretNested<A> editPullSecret();
    public A withNewPullSecret(String name);
    public A addToRuntimeArtifacts(ImageSourcePath... items);
    public A removeFromRuntimeArtifacts(ImageSourcePath... items);
    public List<ImageSourcePath> getRuntimeArtifacts();
    public A withRuntimeArtifacts(List<ImageSourcePath> runtimeArtifacts);
    public A withRuntimeArtifacts(ImageSourcePath... runtimeArtifacts);
    public SourceBuildStrategyFluent.RuntimeArtifactsNested<A> addNewRuntimeArtifact();
    public SourceBuildStrategyFluent.RuntimeArtifactsNested<A> addNewRuntimeArtifactLike(ImageSourcePath item);
    public A addNewRuntimeArtifact(String destinationDir,String sourcePath);
    public ObjectReference getRuntimeImage();
    public A withRuntimeImage(ObjectReference runtimeImage);
    public SourceBuildStrategyFluent.RuntimeImageNested<A> withNewRuntimeImage();
    public SourceBuildStrategyFluent.RuntimeImageNested<A> withNewRuntimeImageLike(ObjectReference item);
    public SourceBuildStrategyFluent.RuntimeImageNested<A> editRuntimeImage();
    public String getScripts();
    public A withScripts(String scripts);

    public interface EnvNested<N> extends Nested<N>,EnvVarFluent<SourceBuildStrategyFluent.EnvNested<N>>{

        
    public N endEnv();    public N and();
}
    public interface FromNested<N> extends Nested<N>,ObjectReferenceFluent<SourceBuildStrategyFluent.FromNested<N>>{

        
    public N endFrom();    public N and();
}
    public interface PullSecretNested<N> extends Nested<N>,LocalObjectReferenceFluent<SourceBuildStrategyFluent.PullSecretNested<N>>{

        
    public N and();    public N endPullSecret();
}
    public interface RuntimeArtifactsNested<N> extends Nested<N>,ImageSourcePathFluent<SourceBuildStrategyFluent.RuntimeArtifactsNested<N>>{

        
    public N endRuntimeArtifact();    public N and();
}
    public interface RuntimeImageNested<N> extends Nested<N>,ObjectReferenceFluent<SourceBuildStrategyFluent.RuntimeImageNested<N>>{

        
    public N endRuntimeImage();    public N and();
}


}
