package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.lang.Object;

public class PolicyRuleFluentImpl<A extends PolicyRuleFluent<A>> extends BaseFluent<A> implements PolicyRuleFluent<A>{

    private List<String> apiGroups = new ArrayList<String>();
    private HasMetadata attributeRestrictions;
    private List<String> nonResourceURLs = new ArrayList<String>();
    private List<String> resourceNames = new ArrayList<String>();
    private List<String> resources = new ArrayList<String>();
    private List<String> verbs = new ArrayList<String>();

    public PolicyRuleFluentImpl(){
    }
    public PolicyRuleFluentImpl(PolicyRule instance){
            this.withApiGroups(instance.getApiGroups()); 
            this.withAttributeRestrictions(instance.getAttributeRestrictions()); 
            this.withNonResourceURLs(instance.getNonResourceURLs()); 
            this.withResourceNames(instance.getResourceNames()); 
            this.withResources(instance.getResources()); 
            this.withVerbs(instance.getVerbs()); 
    }

    public A addToApiGroups(String... items){
            for (String item : items) {this.apiGroups.add(item);} return (A)this;
    }

    public A removeFromApiGroups(String... items){
            for (String item : items) {this.apiGroups.remove(item);} return (A)this;
    }

    public List<String> getApiGroups(){
            return this.apiGroups;
    }

    public A withApiGroups(List<String> apiGroups){
            this.apiGroups.clear();
            if (apiGroups != null) {for (String item : apiGroups){this.addToApiGroups(item);}} return (A) this;
    }

    public A withApiGroups(String... apiGroups){
            this.apiGroups.clear(); if (apiGroups != null) {for (String item :apiGroups){ this.addToApiGroups(item);}} return (A) this;
    }

    public HasMetadata getAttributeRestrictions(){
            return this.attributeRestrictions;
    }

    public A withAttributeRestrictions(HasMetadata attributeRestrictions){
            this.attributeRestrictions=attributeRestrictions; return (A) this;
    }

    public A addToNonResourceURLs(String... items){
            for (String item : items) {this.nonResourceURLs.add(item);} return (A)this;
    }

    public A removeFromNonResourceURLs(String... items){
            for (String item : items) {this.nonResourceURLs.remove(item);} return (A)this;
    }

    public List<String> getNonResourceURLs(){
            return this.nonResourceURLs;
    }

    public A withNonResourceURLs(List<String> nonResourceURLs){
            this.nonResourceURLs.clear();
            if (nonResourceURLs != null) {for (String item : nonResourceURLs){this.addToNonResourceURLs(item);}} return (A) this;
    }

    public A withNonResourceURLs(String... nonResourceURLs){
            this.nonResourceURLs.clear(); if (nonResourceURLs != null) {for (String item :nonResourceURLs){ this.addToNonResourceURLs(item);}} return (A) this;
    }

    public A addToResourceNames(String... items){
            for (String item : items) {this.resourceNames.add(item);} return (A)this;
    }

    public A removeFromResourceNames(String... items){
            for (String item : items) {this.resourceNames.remove(item);} return (A)this;
    }

    public List<String> getResourceNames(){
            return this.resourceNames;
    }

    public A withResourceNames(List<String> resourceNames){
            this.resourceNames.clear();
            if (resourceNames != null) {for (String item : resourceNames){this.addToResourceNames(item);}} return (A) this;
    }

    public A withResourceNames(String... resourceNames){
            this.resourceNames.clear(); if (resourceNames != null) {for (String item :resourceNames){ this.addToResourceNames(item);}} return (A) this;
    }

    public A addToResources(String... items){
            for (String item : items) {this.resources.add(item);} return (A)this;
    }

    public A removeFromResources(String... items){
            for (String item : items) {this.resources.remove(item);} return (A)this;
    }

    public List<String> getResources(){
            return this.resources;
    }

    public A withResources(List<String> resources){
            this.resources.clear();
            if (resources != null) {for (String item : resources){this.addToResources(item);}} return (A) this;
    }

    public A withResources(String... resources){
            this.resources.clear(); if (resources != null) {for (String item :resources){ this.addToResources(item);}} return (A) this;
    }

    public A addToVerbs(String... items){
            for (String item : items) {this.verbs.add(item);} return (A)this;
    }

    public A removeFromVerbs(String... items){
            for (String item : items) {this.verbs.remove(item);} return (A)this;
    }

    public List<String> getVerbs(){
            return this.verbs;
    }

    public A withVerbs(List<String> verbs){
            this.verbs.clear();
            if (verbs != null) {for (String item : verbs){this.addToVerbs(item);}} return (A) this;
    }

    public A withVerbs(String... verbs){
            this.verbs.clear(); if (verbs != null) {for (String item :verbs){ this.addToVerbs(item);}} return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PolicyRuleFluentImpl that = (PolicyRuleFluentImpl) o;
            if (apiGroups != null ? !apiGroups.equals(that.apiGroups) :that.apiGroups != null) return false;
            if (attributeRestrictions != null ? !attributeRestrictions.equals(that.attributeRestrictions) :that.attributeRestrictions != null) return false;
            if (nonResourceURLs != null ? !nonResourceURLs.equals(that.nonResourceURLs) :that.nonResourceURLs != null) return false;
            if (resourceNames != null ? !resourceNames.equals(that.resourceNames) :that.resourceNames != null) return false;
            if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
            if (verbs != null ? !verbs.equals(that.verbs) :that.verbs != null) return false;
            return true;
    }




}
