package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.Object;

public class JenkinsPipelineBuildStrategyFluentImpl<A extends JenkinsPipelineBuildStrategyFluent<A>> extends BaseFluent<A> implements JenkinsPipelineBuildStrategyFluent<A>{

    private String jenkinsfile;
    private String jenkinsfilePath;

    public JenkinsPipelineBuildStrategyFluentImpl(){
    }
    public JenkinsPipelineBuildStrategyFluentImpl(JenkinsPipelineBuildStrategy instance){
            this.withJenkinsfile(instance.getJenkinsfile()); 
            this.withJenkinsfilePath(instance.getJenkinsfilePath()); 
    }

    public String getJenkinsfile(){
            return this.jenkinsfile;
    }

    public A withJenkinsfile(String jenkinsfile){
            this.jenkinsfile=jenkinsfile; return (A) this;
    }

    public String getJenkinsfilePath(){
            return this.jenkinsfilePath;
    }

    public A withJenkinsfilePath(String jenkinsfilePath){
            this.jenkinsfilePath=jenkinsfilePath; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            JenkinsPipelineBuildStrategyFluentImpl that = (JenkinsPipelineBuildStrategyFluentImpl) o;
            if (jenkinsfile != null ? !jenkinsfile.equals(that.jenkinsfile) :that.jenkinsfile != null) return false;
            if (jenkinsfilePath != null ? !jenkinsfilePath.equals(that.jenkinsfilePath) :that.jenkinsfilePath != null) return false;
            return true;
    }




}
