package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.util.List;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.lang.String;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;

public interface ImageSourceFluent<A extends ImageSourceFluent<A>> extends Fluent<A>{


    public ObjectReference getFrom();
    public A withFrom(ObjectReference from);
    public ImageSourceFluent.FromNested<A> withNewFrom();
    public ImageSourceFluent.FromNested<A> withNewFromLike(ObjectReference item);
    public ImageSourceFluent.FromNested<A> editFrom();
    public A addToPaths(ImageSourcePath... items);
    public A removeFromPaths(ImageSourcePath... items);
    public List<ImageSourcePath> getPaths();
    public A withPaths(List<ImageSourcePath> paths);
    public A withPaths(ImageSourcePath... paths);
    public ImageSourceFluent.PathsNested<A> addNewPath();
    public ImageSourceFluent.PathsNested<A> addNewPathLike(ImageSourcePath item);
    public A addNewPath(String destinationDir,String sourcePath);
    public LocalObjectReference getPullSecret();
    public A withPullSecret(LocalObjectReference pullSecret);
    public ImageSourceFluent.PullSecretNested<A> withNewPullSecret();
    public ImageSourceFluent.PullSecretNested<A> withNewPullSecretLike(LocalObjectReference item);
    public ImageSourceFluent.PullSecretNested<A> editPullSecret();
    public A withNewPullSecret(String name);

    public interface FromNested<N> extends Nested<N>,ObjectReferenceFluent<ImageSourceFluent.FromNested<N>>{

        
    public N endFrom();    public N and();
}
    public interface PathsNested<N> extends Nested<N>,ImageSourcePathFluent<ImageSourceFluent.PathsNested<N>>{

        
    public N and();    public N endPath();
}
    public interface PullSecretNested<N> extends Nested<N>,LocalObjectReferenceFluent<ImageSourceFluent.PullSecretNested<N>>{

        
    public N and();    public N endPullSecret();
}


}
