package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.Long;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;

public interface ImageFluent<A extends ImageFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getDockerImageConfig();
    public A withDockerImageConfig(String dockerImageConfig);
    public A addToDockerImageLayers(ImageLayer... items);
    public A removeFromDockerImageLayers(ImageLayer... items);
    public List<ImageLayer> getDockerImageLayers();
    public A withDockerImageLayers(List<ImageLayer> dockerImageLayers);
    public A withDockerImageLayers(ImageLayer... dockerImageLayers);
    public ImageFluent.DockerImageLayersNested<A> addNewDockerImageLayer();
    public ImageFluent.DockerImageLayersNested<A> addNewDockerImageLayerLike(ImageLayer item);
    public A addNewDockerImageLayer(String mediaType,String name,Long size);
    public String getDockerImageManifest();
    public A withDockerImageManifest(String dockerImageManifest);
    public String getDockerImageManifestMediaType();
    public A withDockerImageManifestMediaType(String dockerImageManifestMediaType);
    public HasMetadata getDockerImageMetadata();
    public A withDockerImageMetadata(HasMetadata dockerImageMetadata);
    public String getDockerImageMetadataVersion();
    public A withDockerImageMetadataVersion(String dockerImageMetadataVersion);
    public String getDockerImageReference();
    public A withDockerImageReference(String dockerImageReference);
    public A addToDockerImageSignatures(String... items);
    public A removeFromDockerImageSignatures(String... items);
    public List<String> getDockerImageSignatures();
    public A withDockerImageSignatures(List<String> dockerImageSignatures);
    public A withDockerImageSignatures(String... dockerImageSignatures);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public ImageFluent.MetadataNested<A> withNewMetadata();
    public ImageFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ImageFluent.MetadataNested<A> editMetadata();
    public A addToSignatures(ImageSignature... items);
    public A removeFromSignatures(ImageSignature... items);
    public List<ImageSignature> getSignatures();
    public A withSignatures(List<ImageSignature> signatures);
    public A withSignatures(ImageSignature... signatures);
    public ImageFluent.SignaturesNested<A> addNewSignature();
    public ImageFluent.SignaturesNested<A> addNewSignatureLike(ImageSignature item);

    public interface DockerImageLayersNested<N> extends Nested<N>,ImageLayerFluent<ImageFluent.DockerImageLayersNested<N>>{

        
    public N and();    public N endDockerImageLayer();
}
    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<ImageFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SignaturesNested<N> extends Nested<N>,ImageSignatureFluent<ImageFluent.SignaturesNested<N>>{

        
    public N and();    public N endSignature();
}


}
