package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;

public interface DeploymentStrategyFluent<A extends DeploymentStrategyFluent<A>> extends Fluent<A>{


    public A addToAnnotations(String key,String value);
    public A addToAnnotations(Map<String,String> map);
    public A removeFromAnnotations(String key);
    public A removeFromAnnotations(Map<String,String> map);
    public Map<String,String> getAnnotations();
    public A withAnnotations(Map<String,String> annotations);
    public CustomDeploymentStrategyParams getCustomParams();
    public A withCustomParams(CustomDeploymentStrategyParams customParams);
    public DeploymentStrategyFluent.CustomParamsNested<A> withNewCustomParams();
    public DeploymentStrategyFluent.CustomParamsNested<A> withNewCustomParamsLike(CustomDeploymentStrategyParams item);
    public DeploymentStrategyFluent.CustomParamsNested<A> editCustomParams();
    public A addToLabels(String key,String value);
    public A addToLabels(Map<String,String> map);
    public A removeFromLabels(String key);
    public A removeFromLabels(Map<String,String> map);
    public Map<String,String> getLabels();
    public A withLabels(Map<String,String> labels);
    public RecreateDeploymentStrategyParams getRecreateParams();
    public A withRecreateParams(RecreateDeploymentStrategyParams recreateParams);
    public DeploymentStrategyFluent.RecreateParamsNested<A> withNewRecreateParams();
    public DeploymentStrategyFluent.RecreateParamsNested<A> withNewRecreateParamsLike(RecreateDeploymentStrategyParams item);
    public DeploymentStrategyFluent.RecreateParamsNested<A> editRecreateParams();
    public ResourceRequirements getResources();
    public A withResources(ResourceRequirements resources);
    public DeploymentStrategyFluent.ResourcesNested<A> withNewResources();
    public DeploymentStrategyFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item);
    public DeploymentStrategyFluent.ResourcesNested<A> editResources();
    public RollingDeploymentStrategyParams getRollingParams();
    public A withRollingParams(RollingDeploymentStrategyParams rollingParams);
    public DeploymentStrategyFluent.RollingParamsNested<A> withNewRollingParams();
    public DeploymentStrategyFluent.RollingParamsNested<A> withNewRollingParamsLike(RollingDeploymentStrategyParams item);
    public DeploymentStrategyFluent.RollingParamsNested<A> editRollingParams();
    public String getType();
    public A withType(String type);

    public interface CustomParamsNested<N> extends Nested<N>,CustomDeploymentStrategyParamsFluent<DeploymentStrategyFluent.CustomParamsNested<N>>{

        
    public N endCustomParams();    public N and();
}
    public interface RecreateParamsNested<N> extends Nested<N>,RecreateDeploymentStrategyParamsFluent<DeploymentStrategyFluent.RecreateParamsNested<N>>{

        
    public N and();    public N endRecreateParams();
}
    public interface ResourcesNested<N> extends Nested<N>,ResourceRequirementsFluent<DeploymentStrategyFluent.ResourcesNested<N>>{

        
    public N and();    public N endResources();
}
    public interface RollingParamsNested<N> extends Nested<N>,RollingDeploymentStrategyParamsFluent<DeploymentStrategyFluent.RollingParamsNested<N>>{

        
    public N and();    public N endRollingParams();
}


}
