package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.util.List;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;

public interface BuildSourceFluent<A extends BuildSourceFluent<A>> extends Fluent<A>{


    public BinaryBuildSource getBinary();
    public A withBinary(BinaryBuildSource binary);
    public BuildSourceFluent.BinaryNested<A> withNewBinary();
    public BuildSourceFluent.BinaryNested<A> withNewBinaryLike(BinaryBuildSource item);
    public BuildSourceFluent.BinaryNested<A> editBinary();
    public A withNewBinary(String asFile);
    public String getContextDir();
    public A withContextDir(String contextDir);
    public String getDockerfile();
    public A withDockerfile(String dockerfile);
    public GitBuildSource getGit();
    public A withGit(GitBuildSource git);
    public BuildSourceFluent.GitNested<A> withNewGit();
    public BuildSourceFluent.GitNested<A> withNewGitLike(GitBuildSource item);
    public BuildSourceFluent.GitNested<A> editGit();
    public A withNewGit(String httpProxy,String httpsProxy,String ref,String uri);
    public A addToImages(ImageSource... items);
    public A removeFromImages(ImageSource... items);
    public List<ImageSource> getImages();
    public A withImages(List<ImageSource> images);
    public A withImages(ImageSource... images);
    public BuildSourceFluent.ImagesNested<A> addNewImage();
    public BuildSourceFluent.ImagesNested<A> addNewImageLike(ImageSource item);
    public A addToSecrets(SecretBuildSource... items);
    public A removeFromSecrets(SecretBuildSource... items);
    public List<SecretBuildSource> getSecrets();
    public A withSecrets(List<SecretBuildSource> secrets);
    public A withSecrets(SecretBuildSource... secrets);
    public BuildSourceFluent.SecretsNested<A> addNewSecret();
    public BuildSourceFluent.SecretsNested<A> addNewSecretLike(SecretBuildSource item);
    public LocalObjectReference getSourceSecret();
    public A withSourceSecret(LocalObjectReference sourceSecret);
    public BuildSourceFluent.SourceSecretNested<A> withNewSourceSecret();
    public BuildSourceFluent.SourceSecretNested<A> withNewSourceSecretLike(LocalObjectReference item);
    public BuildSourceFluent.SourceSecretNested<A> editSourceSecret();
    public A withNewSourceSecret(String name);
    public String getType();
    public A withType(String type);

    public interface BinaryNested<N> extends Nested<N>,BinaryBuildSourceFluent<BuildSourceFluent.BinaryNested<N>>{

        
    public N and();    public N endBinary();
}
    public interface GitNested<N> extends Nested<N>,GitBuildSourceFluent<BuildSourceFluent.GitNested<N>>{

        
    public N and();    public N endGit();
}
    public interface ImagesNested<N> extends Nested<N>,ImageSourceFluent<BuildSourceFluent.ImagesNested<N>>{

        
    public N and();    public N endImage();
}
    public interface SecretsNested<N> extends Nested<N>,SecretBuildSourceFluent<BuildSourceFluent.SecretsNested<N>>{

        
    public N and();    public N endSecret();
}
    public interface SourceSecretNested<N> extends Nested<N>,LocalObjectReferenceFluent<BuildSourceFluent.SourceSecretNested<N>>{

        
    public N and();    public N endSourceSecret();
}


}
