package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;

public interface BuildFluent<A extends BuildFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public BuildFluent.MetadataNested<A> withNewMetadata();
    public BuildFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public BuildFluent.MetadataNested<A> editMetadata();
    public BuildSpec getSpec();
    public A withSpec(BuildSpec spec);
    public BuildFluent.SpecNested<A> withNewSpec();
    public BuildFluent.SpecNested<A> withNewSpecLike(BuildSpec item);
    public BuildFluent.SpecNested<A> editSpec();
    public BuildStatus getStatus();
    public A withStatus(BuildStatus status);
    public BuildFluent.StatusNested<A> withNewStatus();
    public BuildFluent.StatusNested<A> withNewStatusLike(BuildStatus item);
    public BuildFluent.StatusNested<A> editStatus();

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<BuildFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,BuildSpecFluent<BuildFluent.SpecNested<N>>{

        
    public N endSpec();    public N and();
}
    public interface StatusNested<N> extends Nested<N>,BuildStatusFluent<BuildFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
