package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface IngressRuleFluent<A extends IngressRuleFluent<A>> extends Fluent<A>{


    public String getHost();
    public A withHost(String host);
    public HTTPIngressRuleValue getHttp();
    public A withHttp(HTTPIngressRuleValue http);
    public IngressRuleFluent.HttpNested<A> withNewHttp();
    public IngressRuleFluent.HttpNested<A> withNewHttpLike(HTTPIngressRuleValue item);
    public IngressRuleFluent.HttpNested<A> editHttp();

    public interface HttpNested<N> extends Nested<N>,HTTPIngressRuleValueFluent<IngressRuleFluent.HttpNested<N>>{

        
    public N and();    public N endHttp();
}


}
