package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.List;
import javax.validation.Valid;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;

public class HorizontalPodAutoscalerListFluentImpl<A extends HorizontalPodAutoscalerListFluent<A>> extends BaseFluent<A> implements HorizontalPodAutoscalerListFluent<A>{

    private String apiVersion;
    private List<VisitableBuilder<? extends HorizontalPodAutoscaler,?>> items =  new ArrayList<VisitableBuilder<? extends HorizontalPodAutoscaler,?>>();
    private String kind;
    private VisitableBuilder<? extends ListMeta,?> metadata;

    public HorizontalPodAutoscalerListFluentImpl(){
    }
    public HorizontalPodAutoscalerListFluentImpl(HorizontalPodAutoscalerList instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public A addToItems(HorizontalPodAutoscaler... items){
            for (HorizontalPodAutoscaler item : items) {HorizontalPodAutoscalerBuilder builder = new HorizontalPodAutoscalerBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromItems(HorizontalPodAutoscaler... items){
            for (HorizontalPodAutoscaler item : items) {HorizontalPodAutoscalerBuilder builder = new HorizontalPodAutoscalerBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public List<HorizontalPodAutoscaler> getItems(){
            return build(items);
    }

    public A withItems(List<HorizontalPodAutoscaler> items){
            this.items.clear();
            if (items != null) {for (HorizontalPodAutoscaler item : items){this.addToItems(item);}} return (A) this;
    }

    public A withItems(HorizontalPodAutoscaler... items){
            this.items.clear(); if (items != null) {for (HorizontalPodAutoscaler item :items){ this.addToItems(item);}} return (A) this;
    }

    public HorizontalPodAutoscalerListFluent.ItemsNested<A> addNewItem(){
            return new ItemsNestedImpl();
    }

    public HorizontalPodAutoscalerListFluent.ItemsNested<A> addNewItemLike(HorizontalPodAutoscaler item){
            return new ItemsNestedImpl(item);
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public ListMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ListMeta metadata){
            if (metadata!=null){ this.metadata= new ListMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public HorizontalPodAutoscalerListFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public HorizontalPodAutoscalerListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item){
            return new MetadataNestedImpl(item);
    }

    public HorizontalPodAutoscalerListFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public A withNewMetadata(String resourceVersion,String selfLink){
            return (A)withMetadata(new ListMeta(resourceVersion, selfLink));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            HorizontalPodAutoscalerListFluentImpl that = (HorizontalPodAutoscalerListFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (items != null ? !items.equals(that.items) :that.items != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            return true;
    }


    public class ItemsNestedImpl<N> extends HorizontalPodAutoscalerFluentImpl<HorizontalPodAutoscalerListFluent.ItemsNested<N>> implements HorizontalPodAutoscalerListFluent.ItemsNested<N>,Nested<N>{

            private final HorizontalPodAutoscalerBuilder builder;
    
            ItemsNestedImpl(){
                    this.builder = new HorizontalPodAutoscalerBuilder(this);
            }
            ItemsNestedImpl(HorizontalPodAutoscaler item){
                    this.builder = new HorizontalPodAutoscalerBuilder(this, item);
            }
    
    public N endItem(){
            return and();
    }
    public N and(){
            return (N) HorizontalPodAutoscalerListFluentImpl.this.addToItems(builder.build());
    }

}
    public class MetadataNestedImpl<N> extends ListMetaFluentImpl<HorizontalPodAutoscalerListFluent.MetadataNested<N>> implements HorizontalPodAutoscalerListFluent.MetadataNested<N>,Nested<N>{

            private final ListMetaBuilder builder;
    
            MetadataNestedImpl(){
                    this.builder = new ListMetaBuilder(this);
            }
            MetadataNestedImpl(ListMeta item){
                    this.builder = new ListMetaBuilder(this, item);
            }
    
    public N and(){
            return (N) HorizontalPodAutoscalerListFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}


}
