package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;

public interface DaemonSetListFluent<A extends DaemonSetListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(DaemonSet... items);
    public A removeFromItems(DaemonSet... items);
    public List<DaemonSet> getItems();
    public A withItems(List<DaemonSet> items);
    public A withItems(DaemonSet... items);
    public DaemonSetListFluent.ItemsNested<A> addNewItem();
    public DaemonSetListFluent.ItemsNested<A> addNewItemLike(DaemonSet item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public DaemonSetListFluent.MetadataNested<A> withNewMetadata();
    public DaemonSetListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public DaemonSetListFluent.MetadataNested<A> editMetadata();
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,DaemonSetFluent<DaemonSetListFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<DaemonSetListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
