package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.lang.Integer;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Nested;

public interface StatusDetailsFluent<A extends StatusDetailsFluent<A>> extends Fluent<A>{


    public A addToCauses(StatusCause... items);
    public A removeFromCauses(StatusCause... items);
    public List<StatusCause> getCauses();
    public A withCauses(List<StatusCause> causes);
    public A withCauses(StatusCause... causes);
    public StatusDetailsFluent.CausesNested<A> addNewCause();
    public StatusDetailsFluent.CausesNested<A> addNewCauseLike(StatusCause item);
    public A addNewCause(String field,String message,String reason);
    public String getGroup();
    public A withGroup(String group);
    public String getKind();
    public A withKind(String kind);
    public String getName();
    public A withName(String name);
    public Integer getRetryAfterSeconds();
    public A withRetryAfterSeconds(Integer retryAfterSeconds);

    public interface CausesNested<N> extends Nested<N>,StatusCauseFluent<StatusDetailsFluent.CausesNested<N>>{

        
    public N endCause();    public N and();
}


}
