package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface SecretVolumeSourceFluent<A extends SecretVolumeSourceFluent<A>> extends Fluent<A>{


    public A addToItems(KeyToPath... items);
    public A removeFromItems(KeyToPath... items);
    public List<KeyToPath> getItems();
    public A withItems(List<KeyToPath> items);
    public A withItems(KeyToPath... items);
    public SecretVolumeSourceFluent.ItemsNested<A> addNewItem();
    public SecretVolumeSourceFluent.ItemsNested<A> addNewItemLike(KeyToPath item);
    public A addNewItem(String key,String path);
    public String getSecretName();
    public A withSecretName(String secretName);

    public interface ItemsNested<N> extends Nested<N>,KeyToPathFluent<SecretVolumeSourceFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}


}
